/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.deployment.annotation.introspection;

import java.util.HashSet;
import java.util.Set;

/**
 * Abstract superclass for instance-based annotation scanners.
 *
 * @author tjquinn
 */
public abstract class AbstractAnnotationScanner implements CustomAnnotationScanner {
    
    /** holds the annotations of interest to the specific type of scanner */
    protected Set<String> annotations=null;
    
    /** Creates a new instance of AbstractAnnotationScanner */
    public AbstractAnnotationScanner() {
    }
  
    /**
     * Invoked so the concrete subclass can populate the annotations set.
     * <p>
     * Concrete implementations of this method should add to the set one or more Strings 
     * corresponding to the annotations of interest.  
     *
     * @param annotationsSet the Set object to be populated
     */
    protected abstract void init(Set<String> annotationsSet);

    /**
     * Test if the passed constant pool string is a reference to 
     * a Type.TYPE annotation of a J2EE component
     *
     * @String the constant pool info string 
     * @return true if it is an annotation reference of interest to this scanner
     */
    public boolean isAnnotation(String value) {
        if (annotations==null) {
            synchronized(this) {
                if (annotations == null) {
                    annotations = new HashSet();
                    init(annotations);
                }
            }
        }
        return annotations.contains(value);
    }
}
