/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.deploy.shared;

import java.io.OutputStream;
import java.io.InputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.jar.Manifest;
import java.util.Vector;

import com.sun.enterprise.deployment.deploy.shared.WritableArchive;
import com.sun.enterprise.deployment.deploy.shared.Archive;

/**
 * This abstract class contains all common implementation of the 
 * Archive/WritableArchive interfaces for all types of archives.
 *
 * @author Jerome Dochez
 */
public abstract class AbstractArchive implements WritableArchive {

    /** 
     * @return the archive uri
     */ 
    public abstract String getArchiveUri();

    /**
     * @return the size of the archive
     */
     public abstract long getArchiveSize() throws NullPointerException, SecurityException;
                
    /**
     * @return an @see java.util.Enumeration of entries in this abstract
     * archive, providing the list of embedded archive to not count their 
     * entries as part of this archive
     */
    public abstract Enumeration entries(Enumeration embeddedArchives);    
    
    /**
     * @return true if this archive exists
     */
    public abstract boolean exists();
    
    /**
     * deletes the archive
     */
    public abstract boolean delete();
    
    /**
     * rename the archive
     *
     * @param name the archive name
     */
    public abstract boolean renameTo(String name);
    
    /**
     * @return true if this archive abstraction supports overwriting of elements
     */
    public boolean supportsElementsOverwriting() {
        return false;
    }
    
    /**
     * @return the sub archive
     */
    public Archive getSubArchive(String name) throws IOException {
        return getEmbeddedArchive(name);
    }
    
    /**
     * close a sub archive
     */
    public abstract void closeEntry(AbstractArchive sub) throws IOException;
    
    public abstract AbstractArchive getEmbeddedArchive(String name) 
        throws IOException;

    /** 
     * Returns an enumeration of the module file entries with the
     * specified prefix.  All elements in the enumeration are of 
     * type String.  Each String represents a file name relative 
     * to the root of the module. 
     * 
     * @param prefix the prefix of entries to be included
     * @return an enumeration of the archive file entries. 
     */ 
    public Enumeration entries(String prefix) {
        Enumeration allEntries = entries();
        Vector entries = new Vector();
        while (allEntries.hasMoreElements()) {
            String name = (String) allEntries.nextElement();
            if (name != null && name.startsWith(prefix)) {
                entries.add(name);
            }
        }
        return entries.elements();
    }
}
