/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.deploy.shared;

import java.io.IOException;

/**
 * This interface defines the behaviour for obtaining an abstraction
 * of the Jar file protocol. The interface implementation returned 
 * by the methods of this interface will abstract the necessary 
 * protocol used by the archivists to open/store J2EE Bundles.
 *
 * @author Jerome ochez
 */
public interface AbstractArchiveFactory {    

    /**
     * create a new archive abstraction with the given path and 
     * return an implementation responsible for storing elements 
     * to this archive abstraction
     *
     * @param path for the new archive
     * @return the abstraction to manipulate the archive
     */
    AbstractArchive createArchive(String path)  throws IOException;    
    
    /**
     * open an existing archive described by the path and return 
     * an implementation responsible for retrieving eleemnts from 
     * this archive abstraction
     *
     * @param path for the existing archive
     * @return the abstraction to get entries from
     */
    AbstractArchive openArchive(String path)  throws IOException;
    
    
}
