/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.deploy.shared;

import java.io.IOException;

/**
 * Abstract Archive factory to create archive abstractions based 
 * on directory structures
 *
 * @author Jerome Dochez
 */
public class FileArchiveFactory implements AbstractArchiveFactory {
        
    /**
     * create a new archive abstraction with the given path and
     * return an implementation responsible for storing elements
     * to this archive abstraction
     *
     * @param path for the new archive
     * @return the abstraction to manipulate the archive
     */
    public AbstractArchive createArchive(String path) throws IOException {
        FileArchive output = new FileArchive();
        output.create(path);        
        return output;        
    }
    
    /**
     * open an existing archive described by the path and return
     * an implementation responsible for retrieving eleemnts from
     * this archive abstraction
     *
     * @param path for the existing archive
     * @return the abstraction to get entries from
     */
    public AbstractArchive openArchive(String path) throws IOException {
        FileArchive input = new FileArchive();
        input.open(path);        
        return input;
    }
    
}
