/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.deployment.interfaces;

/**
 *
 * @author  dochez
 */
public interface SecurityRoleMapperFactory {
    
     /**
     * Returns a RoleMapper corresponding to the AppName.
     * @param The Application Name of this RoleMapper.
     */
    public SecurityRoleMapper getRoleMapper(String appName);
    
    /**
     * remove the RoleMapping associated with this application
     * @param the application name for this RoleMapper
     */
    public void removeRoleMapper(String appName);
    
    /**
     * Sets a new RoleMapper for a particular Application
     * @param the application name
     * @param the new role mapper
     */
    public void setRoleMapper(String appName, SecurityRoleMapper rmap); 
    
    /**
     * Returns the appname for this particular context id. Used in 
     * context of a web application
     */
    public String getAppNameForContext(String contextId);
    /**
     * stores the appname for this particular context id. Used in the
     * context of a web application
     */
    public void setAppNameForContext(String appName, String contextId);
    
    /**
     * removes the link between contextId and the appname
     */
    public void removeAppNameForContext(String contextId);
}
