/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.enterprise.deployment.io;

import com.sun.enterprise.deployment.node.RootXMLNode;
import com.sun.enterprise.deployment.node.PersistenceNode;
import com.sun.enterprise.deployment.*;

/**
 * @author Sanjeeb.Sahoo@Sun.COM
 */
public class PersistenceDeploymentDescriptorFile extends DeploymentDescriptorFile {
    public String getDeploymentDescriptorPath() {
        return DescriptorConstants.PERSISTENCE_DD_ENTRY;
    }

    public RootXMLNode getRootXMLNode(Descriptor descriptor) {
        // This method is called from SaxParserHandler.startElement() method
        // as well as DeploymentDescriptorFile.getDefaultSchemaSource().
        // When it is called from former method, descriptor is non-null,
        // but when it is called later method, descriptor is null.
        if(descriptor==null ||
                descriptor instanceof Application ||
                descriptor instanceof ApplicationClientDescriptor ||
                descriptor instanceof EjbBundleDescriptor ||
                descriptor instanceof WebBundleDescriptor) {
            return new PersistenceNode(new PersistenceUnitsDescriptor());
        } else {
            throw new IllegalArgumentException(descriptor.getClass().getName()+
                    "is not allowed to contain persistence.xml file");
        }
    }

    /**
     * The returned string is used to set up the schema location in SaxParser.
     * @return returns a string with format similar to what is used in
     * schemaLocation attribute in XML docs. i.e. it returns a list of pairs,
     * where each pair consists of a namespace and url pointing to the schema
     * doc.
     */
    @Override protected String getDefaultSchemaSource() {
        // This method is overridden because the implementation in
        // super class is not correctly implemented. See bug#6340561
        PersistenceNode rootXMLNode =
                PersistenceNode.class.cast(getRootXMLNode(null));
        return rootXMLNode.getNameSpace() + " " + rootXMLNode.getSystemID();
    }
}
