/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.node;

import java.util.Vector;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Node;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.ContainerTransaction;
import com.sun.enterprise.deployment.xml.EjbTagNames;
/**
 * This node is responsible for handling the container-transaction XML node
 *
 * @author  Jerome Dochez
 * @version 
 */
public class ContainerTransactionNode extends DeploymentDescriptorNode {

    private String trans_attribute;
    private String description;    
    private Vector methods = new Vector();
    
    /** Creates new ContainerTransactionNode */
    public ContainerTransactionNode() {
       registerElementHandler(new XMLElement(EjbTagNames.METHOD), MethodNode.class);                         
    }
    
    /**
     * Adds  a new DOL descriptor instance to the descriptor instance associated with 
     * this XMLNode
     *
     * @param descriptor the new descriptor
     */    
    public void addDescriptor(Object newDescriptor) {
        if (newDescriptor instanceof MethodDescriptor) {
            methods.add(newDescriptor);
        }
    }

    /**
     * @return the Descriptor subclass that was populated  by reading
     * the source XML file
     */
    public Object getDescriptor() {
        return null;
    }
    
    /** 
     * receives notification of the end of an XML element by the Parser
     * 
     * @param element the xml tag identification
     * @return true if this node is done processing the XML sub tree
     */    
    public boolean endElement(XMLElement element) {
        boolean doneWithNode = super.endElement(element);
        
        if (doneWithNode) {
            ContainerTransaction ct =  new ContainerTransaction(trans_attribute, description);
            for (Iterator methodsIterator = methods.iterator();methodsIterator.hasNext();) {
                MethodDescriptor md = (MethodDescriptor) methodsIterator.next();
                EjbBundleDescriptor bundle = (EjbBundleDescriptor) getParentNode().getDescriptor();
                EjbDescriptor ejb = bundle.getEjbByName(md.getEjbName());
                ejb.getMethodContainerTransactions().put(md, ct);
            }
        }        
        return doneWithNode;
    }
    
    /**
     * receives notiification of the value for a particular tag
     * 
     * @param element the xml element
     * @param value it's associated value
     */    
    public void setElementValue(XMLElement element, String value) {
        if (EjbTagNames.DESCRIPTION.equals(element.getQName())) {
            description = value;
        } 
        if (EjbTagNames.TRANSACTION_ATTRIBUTE.equals(element.getQName())) {
            trans_attribute = value;
        }
    }        
    
    /**
     * write the descriptor class to a DOM tree and return it
     *
     * @param parent node in the DOM tree 
     * @param node name for the root element of this xml fragment      
     * @param the descriptor to write
     * @return the DOM tree top node
     */
    public Node writeDescriptor(Node parent, String nodeName, EjbDescriptor ejb) {    
        
        Map methodToTransactions = ejb.getMethodContainerTransactions();
        MethodNode mn = new MethodNode();
        for (Iterator e=methodToTransactions.keySet().iterator();e.hasNext();) {
            MethodDescriptor md = (MethodDescriptor) e.next();
            Node ctNode = super.writeDescriptor(parent, nodeName, ejb);            
            ContainerTransaction ct = (ContainerTransaction) methodToTransactions.get(md);
            appendTextChild(ctNode, EjbTagNames.DESCRIPTION, ct.getDescription());
            mn.writeDescriptor(ctNode, EjbTagNames.METHOD, md, ejb.getName());
            appendTextChild(ctNode, EjbTagNames.TRANSACTION_ATTRIBUTE, ct.getTransactionAttribute());
        }
        return null;
    }
}
