/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.enterprise.deployment.node;

import com.sun.enterprise.deployment.xml.PersistenceTagNames;
import com.sun.enterprise.deployment.PersistenceUnitDescriptor;
import com.sun.enterprise.deployment.PersistenceUnitsDescriptor;

import java.util.ArrayList;
import java.util.List;

/**
 * Represents the top level node, i.e. persistence node in persistence.xsd.
 * Since this is a top level node, it extends {@link BundleNode}. This class
 * registers a handler {@link PersistenceNode} which is responsible for reading
 * the persistence-unit elements.
 *
 * @author Sanjeeb.Sahoo@Sun.COM
 */
public class PersistenceNode extends BundleNode {

    public final static String SCHEMA_NS =
            "http://java.sun.com/xml/ns/persistence"; // NOI18N

    public final static String SCHEMA_ID = "persistence_1_0.xsd"; // NOI18N

    private static List<String> systemIDs = null;

    // The XML tag associated with this Node
    public final static XMLElement ROOT_ELEMENT = new XMLElement(
            PersistenceTagNames.PERSISTENCE);

    private PersistenceUnitsDescriptor persistenceUnitsDescriptor;

    private static final String SPEC_VERSION = "1.0";

    /**
     * This is the default constructor which is also called from other
     * constructors of this class. Inside this constructor, we clear the
     * handlers set up by super classes' constructors because they are
     * not applicable in the context of PersistenceNode because
     * unlike standard Java EE schemas, persistence.xsd does not include
     * javaee_5.xsd for things like description, version etc.
     */
    public PersistenceNode() {
        // clear all the handlers set up by super classes.
        if (handlers != null) handlers.clear();
        registerElementHandler(
                new XMLElement(PersistenceTagNames.PERSISTENCE_UNIT),
                PersistenceUnitNode.class);
    }

    public PersistenceNode(PersistenceUnitsDescriptor persistenceUnitsDescriptor) {
        this();
        this.persistenceUnitsDescriptor = persistenceUnitsDescriptor;
    }

    @Override
    public PersistenceUnitsDescriptor getDescriptor() {
        return persistenceUnitsDescriptor;
    }

    // This method is called when parser has parsed one <persistence-unit>
    @Override
    public void addDescriptor(Object descriptor) {
        final PersistenceUnitDescriptor pud = PersistenceUnitDescriptor.class.cast(descriptor);
        getDescriptor().addPersistenceUnitDescriptor(pud);
    }

    public String getDocType() {
        return null;
    }

    public String getSystemID() {
        return SCHEMA_ID;
    }

    public String getNameSpace() {
        return SCHEMA_NS;
    }

    /**
     * @return the XML tag associated with this XMLNode
     */
    protected XMLElement getXMLRootTag() {
        return ROOT_ELEMENT;
    }

    public List<String> getSystemIDs() {
        if (systemIDs != null) {
            return systemIDs;
        }
        systemIDs = new ArrayList<String>();
        systemIDs.add(SCHEMA_ID);
        return systemIDs;
    }

    public String getSpecVersion() {
        return SPEC_VERSION;
    }

    // Currently this method is commented because
    // it is not needed now as we are not writing out
    // persistence.xml file to generated directory. When we decide to
    // write out a "full" persistence.xml file, we will need this method.
    // When you uncomment, you need to check the actual logic as well.
//    @Override public Node writeDescriptor(Node parent, Descriptor descriptor) {
//        if(descriptor instanceof PersistenceUnitDescriptor) {
//            Element child = getOwnerDocument(parent).createElementNS(TagNames.PERSISTENCE_XML_NAMESPACE, PersistenceTagNames.ENTITY_MANAGER);
//            Element bundleNode = (Element)parent.appendChild(child);
//            bundleNode.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", TagNames.PERSISTENCE_XML_NAMESPACE);
//            bundleNode.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", W3C_XML_SCHEMA_INSTANCE);
//
//            String schemaLocation = TagNames.PERSISTENCE_XML_NAMESPACE + " " + getSchemaURL();
//            String clientSchemaLocation = PersistenceUnitDescriptor.class.cast(descriptor).getSchemaLocation();
//            if (clientSchemaLocation!=null) {
//                schemaLocation = schemaLocation + " " + clientSchemaLocation;
//            }
//            bundleNode.setAttributeNS(W3C_XML_SCHEMA_INSTANCE, SCHEMA_LOCATION_TAG, schemaLocation);
//            TODO: Code for all other elements for this node goes here.
//            return bundleNode;
//        } else {
//            return super.writeDescriptor(parent, descriptor);
//        }
//    }
}
