/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.node;

import java.util.Map;
import org.w3c.dom.Node;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.InjectionTarget;
import com.sun.enterprise.deployment.xml.EjbTagNames;
import com.sun.enterprise.deployment.xml.TagNames;

/**
 * This node handles all resource-ref xml tag elements
 * 
 * @author  Jerome Dochez
 * @version 
 */
public class ResourceRefNode  extends DeploymentDescriptorNode {
    
    public ResourceRefNode() {
        super();
        registerElementHandler(new XMLElement(TagNames.INJECTION_TARGET), 
                                InjectionTargetNode.class, "addInjectionTarget");                          
    }        
  /**
     * all sub-implementation of this class can use a dispatch table to map xml element to
     * method name on the descriptor class for setting the element value. 
     *  
     * @return the map with the element name as a key, the setter method as a value
     */    
    protected Map getDispatchTable() {
        // no need to be synchronized for now
        Map table = super.getDispatchTable();
        table.put(EjbTagNames.RESOURCE_REFERENCE_NAME, "setName");
        table.put(EjbTagNames.RESOURCE_TYPE, "setType");        
        table.put(EjbTagNames.RESOURCE_AUTHORIZATION, "setAuthorization");
        table.put(EjbTagNames.RESOURCE_SHARING_SCOPE, "setSharingScope");
        table.put(TagNames.MAPPED_NAME, "setMappedName");
        return table;
    }
    
    /**
     * write the descriptor class to a DOM tree and return it
     *
     * @param parent node in the DOM tree 
     * @param node name for the root element of this xml fragment      
     * @param the descriptor to write
     * @return the DOM tree top node
     */
    public Node writeDescriptor(Node parent, String nodeName, ResourceReferenceDescriptor descriptor) {    
        Node ejbResNode = appendChild(parent, nodeName);
        writeLocalizedDescriptions(ejbResNode, descriptor);
        
        appendTextChild(ejbResNode, EjbTagNames.RESOURCE_REFERENCE_NAME, descriptor.getName());      
        appendTextChild(ejbResNode, EjbTagNames.RESOURCE_TYPE, descriptor.getType());      
        appendTextChild(ejbResNode, EjbTagNames.RESOURCE_AUTHORIZATION, descriptor.getAuthorization());               
        appendTextChild(ejbResNode, EjbTagNames.RESOURCE_SHARING_SCOPE, descriptor.getSharingScope());  
        appendTextChild(ejbResNode, TagNames.MAPPED_NAME, descriptor.getMappedName());
        if( descriptor.isInjectable() ) {
            InjectionTargetNode ijNode = new InjectionTargetNode();
            for (InjectionTarget target : descriptor.getInjectionTargets()) {
                ijNode.writeDescriptor(ejbResNode, TagNames.INJECTION_TARGET, target);
            }
        }
            
        return ejbResNode;
    }
}
