/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.node;

import java.util.List;
import java.util.Map;

/**
 * This interface defines all the protocol associated with a root node
 * of an XML file. 
 *
 * @author  Jerome Dochez
 * @version 
 */
public interface RootXMLNode  extends XMLNode {
    
    /** 
     * @return the DOCTYPE that should be written to the XML file
     */
    public String getDocType();
    
    /**
     * set the DOCTYPE as read in the input XML File
     * @param DOCTYPE
     */
    public void setDocType(String docType);
    
    /**
     * @return the SystemID of the XML file
     */
    public String getSystemID();

    /**
     * @return the list of SystemID of the XML schema supported
     */
    public List<String> getSystemIDs();
    
    /** 
     * @return the default spec version level this node complies to
     */
    public String getSpecVersion();    
    
}

