/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.node;

import java.util.*;
import org.w3c.dom.Node;

import com.sun.enterprise.deployment.xml.WebServicesTagNames;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import javax.xml.namespace.QName;

/** 
 * This node is responsible for loading web services
 * reference information
 *
 * @author  Kenneth Saks
 */
public class WebServiceNode extends DisplayableComponentNode {

    private final static XMLElement tag = 
        new XMLElement(WebServicesTagNames.WEB_SERVICE);

    public WebServiceNode() {
        super();
        registerElementHandler
            (new XMLElement(WebServicesTagNames.PORT_COMPONENT),
             WebServiceEndpointNode.class);
    }

    /**
     * initilizer method after instance creation
     */
    protected void Init() {
    }
    
    /**
     * all sub-implementation of this class can use a dispatch table 
     * to map xml element to method name on the descriptor class for 
     * setting the element value. 
     *  
     * @return map with the element name as a key, the setter method as a value
     */
    protected Map getDispatchTable() {
        Map table = super.getDispatchTable();
        table.put(WebServicesTagNames.WEB_SERVICE_DESCRIPTION_NAME, 
                  "setName");
        table.put(WebServicesTagNames.WSDL_FILE, "setWsdlFileUri");
        table.put(WebServicesTagNames.JAXRPC_MAPPING_FILE, "setMappingFileUri");
        return table;
    }

    /**
     * @return the XML tag associated with this XMLNode
     */
    protected XMLElement getXMLRootTag() {
        return tag;
    }

    /**
     * Adds  a new DOL descriptor instance to the descriptor 
     * instance associated with this XMLNode
     *
     * @param descriptor the new descriptor
     */
    public void addDescriptor(Object descriptor) {    
        WebServiceEndpoint endpoint = (WebServiceEndpoint) descriptor;
        WebService webService = (WebService) getDescriptor();
        webService.addEndpoint(endpoint);
    }

    /**
     * write the method descriptor class to a query-method DOM tree and 
     * return it
     *
     * @param parent node in the DOM tree 
     * @param node name for the root element of this xml fragment      
     * @param the descriptor to write
     * @return the DOM tree top node
     */
    public Node writeDescriptor(Node parent, String nodeName, 
                                WebService descriptor) {        
        Node topNode = 
            super.writeDescriptor(parent, nodeName, descriptor);

        writeDisplayableComponentInfo(topNode, descriptor);

        appendTextChild(topNode, 
                        WebServicesTagNames.WEB_SERVICE_DESCRIPTION_NAME,
                        descriptor.getName());
        appendTextChild(topNode, WebServicesTagNames.WSDL_FILE,
                        descriptor.getWsdlFileUri());
        appendTextChild(topNode, WebServicesTagNames.JAXRPC_MAPPING_FILE,
                        descriptor.getMappingFileUri());
        
        WebServiceEndpointNode endpointNode = new WebServiceEndpointNode();
        for(WebServiceEndpoint next : descriptor.getEndpoints()) {
            endpointNode.writeDescriptor
                (topNode, WebServicesTagNames.PORT_COMPONENT, next);
        }

        return topNode;
    }    
    
}
