/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

import java.io.IOException;
import java.io.InputStream;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.WebServiceNode;
import com.sun.enterprise.deployment.node.RootXMLNode;
import com.sun.enterprise.deployment.xml.WebServicesTagNames;
import com.sun.enterprise.deployment.xml.TagNames;
import com.sun.enterprise.deployment.util.DOLUtils;

/**
 * Root node for webservices deployment descriptor
 *
 * @author  Kenneth Saks
 * @version 
 */
public class WebServicesDescriptorNode extends BundleNode 
                                    implements RootXMLNode
{    
    public final static XMLElement ROOT_ELEMENT = 
        new XMLElement(WebServicesTagNames.WEB_SERVICES);
    public final static String SCHEMA_ID = "javaee_web_services_1_2.xsd";
    public final static String SPEC_VERSION = "1.2";
    private static List<String> systemIDs = null;

    private BundleDescriptor bundleDescriptor;

    public WebServicesDescriptorNode(BundleDescriptor descriptor) {
        bundleDescriptor = descriptor;
        registerElementHandler(new XMLElement(WebServicesTagNames.WEB_SERVICE),
                               WebServiceNode.class);
    }   

    public WebServicesDescriptorNode() {
        this(null);
    }   
    
    /**
     * @return the DOCTYPE of the XML file
     */
    public String getDocType() {
        return null;
    }
    
    /**
     * @return the SystemID of the XML file
     */
    public String getSystemID() {
        return SCHEMA_ID;
    }

    /**
     * @return the list of SystemID of the XML schema supported
     */
    public List<String> getSystemIDs() {
        if (systemIDs != null) {
            return systemIDs;
        }

        systemIDs = new ArrayList<String>();
        systemIDs.add(SCHEMA_ID);
        return systemIDs;
    }

    /**
     * @return the complete URL for J2EE schemas
     */
    protected String getSchemaURL() {
       return WebServicesTagNames.IBM_NAMESPACE + "/" + getSystemID();
    }    
    
    /**
     * @return the XML tag associated with this XMLNode
     */
    protected XMLElement getXMLRootTag() {
        return ROOT_ELEMENT;
    }
    
    /**
     * receives notiification of the value for a particular tag
     * 
     * @param element the xml element
     * @param value it's associated value
     */    
    public void setElementValue(XMLElement element, String value) {    
        if (TagNames.VERSION.equals(element.getQName())) {    
            bundleDescriptor.getWebServices().setSpecVersion(value);
        } else super.setElementValue(element, value);
    }
        
    /**
     * Adds  a new DOL descriptor instance to the descriptor 
     * instance associated with this XMLNode
     *
     * @param descriptor the new descriptor
     */
    public void addDescriptor(Object descriptor) {    
        WebServicesDescriptor webServicesDesc = 
            bundleDescriptor.getWebServices();
        WebService webService = (WebService) descriptor;
        webServicesDesc.addWebService(webService);
        
        for(Iterator iter = webService.getEndpoints().iterator(); 
            iter.hasNext();) {
            WebServiceEndpoint next = (WebServiceEndpoint) iter.next();
            if( !next.resolveComponentLink() ) {
                DOLUtils.getDefaultLogger().info("Warning: Web service endpoint " + next.getEndpointName() + " component link " + next.getLinkName() + " is not valid");                
            }
        }
        
    }
    
   /**
    * @return the descriptor instance to associate with this XMLNode
    */    
    public Object getDescriptor() {
        return bundleDescriptor;
    }     

    /**
     * write the descriptor class to a DOM tree and return it
     *
     * @param parent node for the DOM tree
     * @param the descriptor to write
     * @return the DOM tree top node
     */    
    public Node writeDescriptor(Node parent, Descriptor descriptor) {    
        Node topNode = parent;
        if (parent instanceof Document) {
            BundleDescriptor bundleDesc = (BundleDescriptor) descriptor;
            WebServicesDescriptor webServicesDesc = bundleDesc.getWebServices();
            topNode = super.writeDescriptor(parent, webServicesDesc);
            WebServiceNode wsNode = new WebServiceNode();
            for(WebService next : webServicesDesc.getWebServices()) {
                wsNode.writeDescriptor(topNode, WebServicesTagNames.WEB_SERVICE,
                                       next);
            }
        }
        return parent;
    }

    /**
     * @return the default spec version level this node complies to
     */
    public String getSpecVersion() {
        return SPEC_VERSION;
    }
    
}

