/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.node.connector;

import java.util.*;
import org.xml.sax.Attributes;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.OutboundResourceAdapter;
import com.sun.enterprise.deployment.AuthMechanism;
import com.sun.enterprise.deployment.SecurityPermission;
import com.sun.enterprise.deployment.xml.ConnectorTagNames;
import com.sun.enterprise.deployment.xml.TagNames;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.node.DescriptorFactory;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.ConfigurableNode;
import com.sun.enterprise.deployment.node.XMLElement;

import com.sun.enterprise.deployment.ConnectorDescriptor;

import org.xml.sax.Attributes;
import org.w3c.dom.Node;

/**
 * This node is responsible for handling the Connector DTD related auth-mechanism XML tag
 *
 * @author  Sheetal Vartak
 * @version 
 */
public class AuthMechNode extends DeploymentDescriptorNode {
    
    private AuthMechanism auth = null;
    
    /**
     * all sub-implementation of this class can use a dispatch table to map xml element to
     * method name on the descriptor class for setting the element value. 
     *  
     * @return the map with the element name as a key, the setter method as a value
     */    

    protected Map getDispatchTable() {    
        Map table = super.getDispatchTable();
        table.put(ConnectorTagNames.CREDENTIAL_INTF, "setCredentialInterface");
        table.put(ConnectorTagNames.AUTH_MECH_TYPE, "setAuthMechVal");
        return table;
    }  

    /**
    * @return the descriptor instance to associate with this XMLNode
    */    
    public Object getDescriptor() {
        if (auth == null) {
            auth = (AuthMechanism) DescriptorFactory.getDescriptor(getXMLPath());
        } 
        return auth;
    } 

    /**
     * write the descriptor class to a DOM tree and return it
     *
     * @param parent node for the DOM tree
     * @param the descriptor to write
     * @return the DOM tree top node
     */    
    public Node writeDescriptor(Node parent, Descriptor descriptor) {

        if (! (descriptor instanceof OutboundResourceAdapter) &&
	    ! (descriptor instanceof ConnectorDescriptor)) {
            throw new IllegalArgumentException(getClass() + " cannot handle descriptors of type " + descriptor.getClass());
        }

	Iterator authMechs = null;

	if (descriptor instanceof ConnectorDescriptor) {
	    authMechs = ((ConnectorDescriptor)descriptor).getAuthMechanisms().iterator();
	} else if (descriptor instanceof OutboundResourceAdapter) {
	    authMechs = ((OutboundResourceAdapter)descriptor).getAuthMechanisms().iterator();
	}

	//auth mechanism info
	for (;authMechs.hasNext();) {
	    AuthMechanism auth = (AuthMechanism) authMechs.next();
	    Node authNode = appendChild(parent, ConnectorTagNames.AUTH_MECHANISM);
	    appendTextChild(authNode, TagNames.DESCRIPTION, auth.getDescription()); 
	    appendTextChild(authNode, ConnectorTagNames.AUTH_MECH_TYPE, auth.getAuthMechType());   
	    appendTextChild(authNode, ConnectorTagNames.CREDENTIAL_INTF, auth.getCredentialInterface());  
	}
	return parent;
    }
}
