/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.node.connector;

import java.util.*;
import org.xml.sax.Attributes;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.OutboundResourceAdapter;
import com.sun.enterprise.deployment.AuthMechanism;
import com.sun.enterprise.deployment.SecurityPermission;
import com.sun.enterprise.deployment.xml.ConnectorTagNames;
import com.sun.enterprise.deployment.xml.TagNames;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.node.DescriptorFactory;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.ConfigurableNode;
import com.sun.enterprise.deployment.node.XMLElement;

import com.sun.enterprise.deployment.ConnectorDescriptor;

import org.xml.sax.Attributes;
import org.w3c.dom.Node;


/**
 * This node is responsible for handling the Connector DTD related security-permission XML tag
 *
 * @author  Sheetal Vartak
 * @version 
 */
public class SecurityPermissionNode extends DeploymentDescriptorNode {
    
    /**
     * all sub-implementation of this class can use a dispatch table to map xml element to
     * method name on the descriptor class for setting the element value. 
     *  
     * @return the map with the element name as a key, the setter method as a value
     */    
    protected Map getDispatchTable() {    
        Map table = super.getDispatchTable();
        table.put(ConnectorTagNames.SECURITY_PERMISSION_SPEC, "setPermission");
	return table;
    }   

    /**
     * write the descriptor class to a DOM tree and return it
     *
     * @param parent node for the DOM tree
     * @param the descriptor to write
     * @return the DOM tree top node
     */    
    public Node writeDescriptor(Node parent, ConnectorDescriptor descriptor) {

	Iterator secPerms = descriptor.getSecurityPermissions().iterator();

	//auth mechanism info
	for (;secPerms.hasNext();) {

	    //for (Iterator secPerms = ((OutboundResourceAdapter)descriptor).getSecurityPermissions().iterator(); secPerms.hasNext();) {
	    SecurityPermission secPerm = (SecurityPermission) secPerms.next();
	    Node secNode = appendChild(parent, ConnectorTagNames.SECURITY_PERMISSION);
            writeLocalizedDescriptions(secNode, secPerm);        
            appendTextChild(secNode, ConnectorTagNames.SECURITY_PERMISSION_SPEC, secPerm.getPermission());  
	}
	return null;
    }
}
