/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * ServletNode.java
 *
 * Created on March 7, 2002, 2:30 PM
 */

package com.sun.enterprise.deployment.node.runtime;

import org.w3c.dom.Node;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.runtime.web.WebBundleRuntimeNode;
import com.sun.enterprise.deployment.xml.RuntimeTagNames;
import com.sun.enterprise.deployment.xml.WebServicesTagNames;

/**
 * This node is handling all runtime deployment descriptors 
 * relative to servlets
 *
 * @author  Jerome Dochez
 * @version 
 */
public class ServletNode extends DeploymentDescriptorNode {

    private WebComponentDescriptor descriptor;

    public ServletNode() {
        registerElementHandler(new XMLElement
            (WebServicesTagNames.WEB_SERVICE_ENDPOINT), 
                               WebServiceEndpointRuntimeNode.class);
    }

    public Object getDescriptor() {
        return descriptor;
    }
    
    /**
     * receives notiification of the value for a particular tag
     * 
     * @param element the xml element
     * @param value it's associated value
     */
    public void setElementValue(XMLElement element, String value) {
        if (RuntimeTagNames.SERVLET_NAME.equals(element.getQName())) {
            Object parentDesc = ((WebBundleRuntimeNode) getParentNode()).getWebBundleDescriptor();
            if (parentDesc instanceof WebBundleDescriptor) {
                descriptor = ((WebBundleDescriptor) parentDesc).getWebComponentByCanonicalName(value);
            }
        } else if (RuntimeTagNames.PRINCIPAL_NAME.equals(element.getQName())) {
            if (descriptor!=null && descriptor.getRunAsIdentity()!=null) {
                descriptor.getRunAsIdentity().setPrincipal(value);
            }
        } else super.setElementValue(element, value);
    }
    

    /**
     * write the descriptor class to a DOM tree and return it
     *
     * @param parent node for the DOM tree
     * @param node name 
     * @param the descriptor to write
     * @return the DOM tree top node
     */    
    public Node writeDescriptor(Node parent, String nodeName, WebComponentDescriptor descriptor) {        
        WebServicesDescriptor webServices = 
            descriptor.getWebBundleDescriptor().getWebServices();

        // only write servlet runtime elements if there is a runas identity
        // or the servlet is exposed as a web service
        if ( (descriptor.getRunAsIdentity() != null) ||
             webServices.hasEndpointsImplementedBy(descriptor) ) {
            Node servletNode =  appendChild(parent, nodeName);
            appendTextChild(servletNode, RuntimeTagNames.SERVLET_NAME, descriptor.getCanonicalName());

            if( descriptor.getRunAsIdentity() != null ) {
                appendTextChild(servletNode, RuntimeTagNames.PRINCIPAL_NAME, 
                                descriptor.getRunAsIdentity().getPrincipal());
            }

            WebServiceEndpointRuntimeNode wsRuntime = 
                new WebServiceEndpointRuntimeNode();
            wsRuntime.writeWebServiceEndpointInfo(servletNode, descriptor);

            return servletNode;
        }
        return null;
    }
}
