/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.node.runtime.common;

import java.util.Iterator;
import java.util.ArrayList;

import org.w3c.dom.Node;

import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.XMLNode;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.MethodNode;
import com.sun.enterprise.deployment.node.runtime.web.WebBundleRuntimeNode;
import com.sun.enterprise.deployment.xml.RuntimeTagNames;
import com.sun.enterprise.deployment.xml.WebServicesTagNames;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.runtime.common.MessageDescriptor;
import com.sun.enterprise.deployment.ServiceRefPortInfo;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;

/**
 * This node handles message element
 *
 */
public class MessageNode extends DeploymentDescriptorNode {

    MessageDescriptor descriptor = null;
    private static final String ALL_METHODS = "*";

    public MessageNode() {
        registerElementHandler(new XMLElement(
            RuntimeTagNames.JAVA_METHOD), MethodNode.class, 
            "setMethodDescriptor");
    }
    
    /**
    * @return the descriptor instance to associate with this XMLNode
    */    
    public Object getDescriptor() {
        if (descriptor == null) {
            descriptor = new MessageDescriptor();
            setMiscDescriptors();
        }
        return descriptor;
    }     

        
    /**
     * receives notification of the value for a particular tag
     *
     * @param element the xml element
     * @param value it's associated value
     */
    public void setElementValue(XMLElement element, String value) {
        if (WebServicesTagNames.OPERATION_NAME.equals(element.getQName())) {
            descriptor.setOperationName(value);
        } else {
            super.setElementValue(element, value);
        }
    }    
    
    /**
     * write the descriptor class to a DOM tree and return it
     *
     * @param parent node for the DOM tree
     * @param node name for 
     * @param the descriptor to write
     * @return the DOM tree top node
     */    
    public Node writeDescriptor(Node parent, String nodeName, 
        MessageDescriptor messageDesc) {    
        Node messageNode = super.writeDescriptor(parent, nodeName,
           messageDesc);

        // for empty message case, set the method descriptor 
        // to a method descriptor with "*" as name
        if (messageDesc.getOperationName() == null && 
            messageDesc.getMethodDescriptor() == null) {
            MethodDescriptor allMethodDesc = new MethodDescriptor();
            allMethodDesc.setName(ALL_METHODS);
            messageDesc.setMethodDescriptor(allMethodDesc);
        }

        // java-method
        MethodDescriptor methodDesc = messageDesc.getMethodDescriptor();
        if (methodDesc != null) {
            MethodNode methodNode = new MethodNode();
            methodNode.writeJavaMethodDescriptor(messageNode,
                RuntimeTagNames.JAVA_METHOD, methodDesc);
        }

        // operation-name
        appendTextChild(messageNode, WebServicesTagNames.OPERATION_NAME, 
            messageDesc.getOperationName());

        return messageNode;
    }

    private void setMiscDescriptors() {
        XMLNode parentNode = 
            getParentNode().getParentNode().getParentNode();

        // get the endpoint or portinfo descriptor
        Object parentDesc = parentNode.getDescriptor();

        if (parentDesc instanceof ServiceRefPortInfo) {
            descriptor.setServiceRefPortInfo((ServiceRefPortInfo)parentDesc);
        } else if(parentDesc instanceof WebServiceEndpoint) {
            descriptor.setWebServiceEndpoint((WebServiceEndpoint)parentDesc);
        }

        // Get the bundle descriptor of which this belongs
        BundleDescriptor bundleDesc = null;
        parentNode = parentNode.getParentNode().getParentNode();
        if (parentNode instanceof WebBundleRuntimeNode) {
            // In the cases of used in
            // 1. webservice-endpoint for web component
            // 2. port-info for web component
            bundleDesc = 
                ((WebBundleRuntimeNode)parentNode).getWebBundleDescriptor(); 
        } else if (parentNode.getDescriptor() instanceof BundleDescriptor) {
            // In the cases of used in port-info for app client
            bundleDesc = (BundleDescriptor)parentNode.getDescriptor(); 
        } else {
            // In the case of used in webservice-endpoint for ejb component
            if (parentNode.getDescriptor() instanceof EjbDescriptor) {
                EjbDescriptor ejbDesc = 
                    (EjbDescriptor)parentNode.getDescriptor();
                bundleDesc = ejbDesc.getEjbBundleDescriptor();
            } else {
                // In the case of used in port-info for ejb component
                parentNode = parentNode.getParentNode();
                if (parentNode.getDescriptor() instanceof EjbDescriptor) {
                    EjbDescriptor ejbDesc = 
                        (EjbDescriptor)parentNode.getDescriptor();
                    bundleDesc = ejbDesc.getEjbBundleDescriptor();
                }
            }
        }
        descriptor.setBundleDescriptor(bundleDesc);
    }
}
