/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.node.runtime.common;

import java.util.ArrayList;
import java.util.Iterator;

import org.w3c.dom.Node;
import org.w3c.dom.Element;

import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.xml.WebServicesTagNames;
import com.sun.enterprise.deployment.runtime.common.MessageSecurityDescriptor;
import com.sun.enterprise.deployment.runtime.common.MessageSecurityBindingDescriptor;

/**
 * This node handles message-security-binding element
 *
 */
public class MessageSecurityBindingNode extends DeploymentDescriptorNode {

    MessageSecurityBindingDescriptor descriptor = null;

    public MessageSecurityBindingNode() {
        registerElementHandler(new XMLElement(
            WebServicesTagNames.MESSAGE_SECURITY), MessageSecurityNode.class, 
            "addMessageSecurityDescriptor");
    }
    
    /**
    * @return the descriptor instance to associate with this XMLNode
    */    
    public Object getDescriptor() {
       if (descriptor == null) {
            descriptor = new MessageSecurityBindingDescriptor();
        }
        return descriptor;
    }     

    /**
     * parsed an attribute of an element
     *
     * @param the element name
     * @param the attribute name
     * @param the attribute value
     * @return true if the attribute was processed
     */
    protected boolean setAttributeValue(XMLElement elementName,
        XMLElement attributeName, String value) {
        if (attributeName.getQName().equals(WebServicesTagNames.AUTH_LAYER)) {
            descriptor.setAttributeValue(descriptor.AUTH_LAYER, value);
            return true;
        } else if (attributeName.getQName().equals(
            WebServicesTagNames.PROVIDER_ID)) {
            descriptor.setAttributeValue(descriptor.PROVIDER_ID, value);
            return true;
        }
        return false;
    }

    /**
     * write the descriptor class to a DOM tree and return it
     *
     * @param parent node for the DOM tree
     * @param node name for 
     * @param the descriptor to write
     * @return the DOM tree top node
     */    
    public Node writeDescriptor(Node parent, String nodeName, 
        MessageSecurityBindingDescriptor messageSecurityBindingDesc) {    
        Element messageSecurityBindingNode = (Element)super.writeDescriptor(parent, nodeName, messageSecurityBindingDesc);

        // message-security
        ArrayList messageSecDescs = 
            messageSecurityBindingDesc.getMessageSecurityDescriptors();
        if (!messageSecDescs.isEmpty()) {
            MessageSecurityNode messageSecurityNode = 
                new MessageSecurityNode();
            for (Iterator messageSecIterator = messageSecDescs.iterator();
                messageSecIterator.hasNext();) {
                MessageSecurityDescriptor messageSecDesc =
                    (MessageSecurityDescriptor) messageSecIterator.next();
                messageSecurityNode.writeDescriptor(messageSecurityBindingNode, WebServicesTagNames.MESSAGE_SECURITY, messageSecDesc);
            }
        }

        // auth-layer
        if (messageSecurityBindingDesc.getAttributeValue(
            messageSecurityBindingDesc.AUTH_LAYER) != null) {
            setAttribute(messageSecurityBindingNode, WebServicesTagNames.AUTH_LAYER, messageSecurityBindingDesc.getAttributeValue(messageSecurityBindingDesc.AUTH_LAYER));
        }
    
        // provider-id
        if (messageSecurityBindingDesc.getAttributeValue(
            messageSecurityBindingDesc.PROVIDER_ID) != null) {
            setAttribute(messageSecurityBindingNode, WebServicesTagNames.PROVIDER_ID, messageSecurityBindingDesc.getAttributeValue(messageSecurityBindingDesc.PROVIDER_ID)); 
        }   
            
        return messageSecurityBindingNode;
    }
}
