/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.node.runtime.common;

import org.w3c.dom.Node;
import org.w3c.dom.Element;

import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.xml.WebServicesTagNames;
import com.sun.enterprise.deployment.runtime.common.ProtectionDescriptor;

/**
 * This node handles request-protection and response-protection elements
 *
 */
public class ProtectionNode extends DeploymentDescriptorNode {

    ProtectionDescriptor descriptor = null;
    
    /**
    * @return the descriptor instance to associate with this XMLNode
    */    
    public Object getDescriptor() {
       if (descriptor == null) {
            descriptor = new ProtectionDescriptor();
        }
        return descriptor;
    }     
        

    /**
     * parsed an attribute of an element
     *  
     * @param the element name
     * @param the attribute name
     * @param the attribute value
     * @return true if the attribute was processed
     */ 
    protected boolean setAttributeValue(XMLElement elementName, 
        XMLElement attributeName, String value) {
        if (attributeName.getQName().equals(WebServicesTagNames.AUTH_SOURCE)) {
            descriptor.setAttributeValue(descriptor.AUTH_SOURCE, value);
            return true;
        } else if (attributeName.getQName().equals(
            WebServicesTagNames.AUTH_RECIPIENT)) {
            descriptor.setAttributeValue(descriptor.AUTH_RECIPIENT, value);
            return true;
        }
        return false;
    }

    /**
     * write the descriptor class to a DOM tree and return it
     *
     * @param parent node for the DOM tree
     * @param node name for 
     * @param the descriptor to write
     * @return the DOM tree top node
     */    
    public Node writeDescriptor(Node parent, String nodeName, 
        ProtectionDescriptor protectionDesc) {    
        Element protectionNode = 
            (Element)super.writeDescriptor(parent, nodeName, protectionDesc);

        // auth-source
        if (protectionDesc.getAttributeValue(protectionDesc.AUTH_SOURCE) 
            != null) {
            setAttribute(protectionNode, WebServicesTagNames.AUTH_SOURCE, protectionDesc.getAttributeValue(protectionDesc.AUTH_SOURCE));
        }

        // auth-recipient
        if (protectionDesc.getAttributeValue(protectionDesc.AUTH_RECIPIENT) 
           != null) {
            setAttribute(protectionNode, WebServicesTagNames.AUTH_RECIPIENT, protectionDesc.getAttributeValue(protectionDesc.AUTH_RECIPIENT));
        }

        return protectionNode;
    }
}
