/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.runtime;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.Descriptor;
/**
 *Records information about Java Web Start access to an app client.
 * @author tjquinn
 */
public class JavaWebStartAccessDescriptor extends Descriptor {
    
    private BundleDescriptor bundleDescriptor;
    
    /** Creates a new instance of JavaWebStartAccessDescriptor */
    public JavaWebStartAccessDescriptor() {
    }

    /**
     * Holds value of property eligible.
     */
    private boolean eligible = true;

    /**
     * Getter for property eligible.
     * @return Value of property eligible.
     */
    public boolean isEligible() {

        return this.eligible;
    }

    /**
     * Setter for property eligible.
     * @param eligible New value of property eligible.
     */
    public void setEligible(boolean eligible) {

        this.eligible = eligible;
    }

    /**
     * Holds value of property contextRoot.
     */
    private String contextRoot = null;

    /**
     * Getter for property contextRoot.
     * @return Value of property contextRoot.
     */
    public String getContextRoot() {

        return this.contextRoot;
    }

    /**
     * Setter for property contextRoot.
     * @param contextRoot New value of property contextRoot.
     */
    public void setContextRoot(String contextRoot) {

        this.contextRoot = contextRoot;
    }
    
    /**
     * Holds value of property vendor.
     */
    private String vendor = null;

    /**
     * Getter for property vendor.
     * @return Value of property vendor.
     */
    public String getVendor() {

        return this.vendor;
    }

    /**
     * Setter for property vendor.
     * @param contextRoot New value of property vendor.
     */
    public void setVendor(String vendor) {

        this.vendor = vendor;
    }
    
    public void setBundleDescriptor(BundleDescriptor bundle) {
        bundleDescriptor = bundle;
    }

    public BundleDescriptor getBundleDescriptor() {
        return bundleDescriptor;
    }

    
}
