/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.runtime.common;

import com.sun.enterprise.deployment.runtime.RuntimeDescriptor;

/**
 * this class is a shameful duplication of info found in normal descriptors
 * it was kept to be backward compatible with the schema2beans descriptors
 * generated by iAS 7.0 engineering team.
 *
 * @author Jerome Dochez
 */
public class EjbRef extends RuntimeDescriptor
{

	static public final String EJB_REF_NAME = "EjbRefName";	// NOI18N
	static public final String JNDI_NAME = "JndiName";	// NOI18N

	// This attribute is mandatory
	public void setEjbRefName(String value)
	{
		this.setValue(EJB_REF_NAME, value);
	}

	//
	public String getEjbRefName()
	{
		return (String)this.getValue(EJB_REF_NAME);
	}

	// This attribute is mandatory
	public void setJndiName(String value)
	{
		this.setValue(JNDI_NAME, value);
	}

	//
	public String getJndiName()
	{
		return (String)this.getValue(JNDI_NAME);
	}

	// This method verifies that the mandatory properties are set
	public boolean verify()
	{
		return true;
	}
}
