/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.util;

import java.net.URL;
import java.net.MalformedURLException;

/**
 * This class holds information about a web server virtual 
 * engine configuration
 *
 * @author Jerome Dochez
 */
public class VirtualServerInfo {
    
    /**
     * Holds value of property host.
     */
    private String host;
    
    /**
     * Holds value of property port.
     */
    private int port;
    
    /**
     * Holds value of property protocol.
     */
    private String protocol;
    
    /** Creates a new instance of VirtualServerInfo */
    public VirtualServerInfo(String protocol, String host, int port) {
        this.protocol = protocol;
        this.host = host;
        this.port = port;
    }
    
    /**
     * Getter for property serverName.
     * @return Value of property serverName.
     */
    public String getHost() {
        return this.host;
    }
    
    /**
     * Getter for property port.
     * @return value of property port.
     */
    public int getPort() {
       return this.port;
    }
    
    /**
     * Getter for property protocol.
     * @return Value of property protocol.
     */
    public String getProtocol() {
        return this.protocol;
    }
    
    /**
     * @return the web server root URL
     */
    public URL getWebServerRootURL() throws MalformedURLException {
        return new URL(protocol, host, port, "");
    }
}
