/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.log;

/**IASRI 4640423 This class was rewritten to redirect everything to System.out or System.err.
 **/
import java.io.PrintStream;

/**
 * This class has public static references to 2 Log objects.
 * <UL>
 * <LI> <B> out </B> : For logging the server Output. By default, the
 *  Output log is set to the PrintStream System.out.
 * <LI> <B> err </B> : For logging the server Errors. By default, the 
 *  Error log is set to the the PrintStream System.err.
 * @author Harish Prabandham
 */
public class Log {
    public static PrintStream out = System.out;
    public static PrintStream err = System.err;    
    
    public static void flushAll() {
	if(System.out != null) 
	    System.out.flush();
	
	if(System.err != null) 
	    System.err.flush();
    }
}





