/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.pluggable;

/**
 * Common utility methods for this package.
 */
public class Utils {

    /**
     * Get non qualified name for the specified class. For example, if this
     * method is passed a parameter representing Class java.lang.Integer, the
     * method will return the string "Integer". If the method is passed a
     * a parameter representing MyFirstJavaClass in default package then it
     * will return the string "MyFirstJavaClass".
     */
    public static String getNQClassName(Class clazz) {
        String nqClassName = null;
        String fqClassName = clazz.getName();
        if (clazz.getPackage() != null) {
            String pkgName = clazz.getPackage().getName();
            nqClassName = fqClassName.substring(pkgName.length() + 1);
        } else {
            nqClassName = fqClassName;
        }
        return nqClassName;
    }
}
