/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Profiler.java
 *
 * Created on September 17, 2001, 12:42 PM
 */

package com.sun.enterprise.util.diagnostics;

import java.util.*;
import com.sun.enterprise.util.diagnostics.Reporter;
import com.sun.enterprise.util.StringUtils;
/**
 * A easy-to-use class that wraps one global ProfilerImpl object.  Use it to begin
 * and end profiling in one 'profiling thread'.  I.e. use this object to get timing for
 * sub-operations.  Use separate ProfilerImpl objects to get timings for overlapping 
 * profile needs.
 *
 * <p> WARNING: Call reset at the end to avoid memory leaks. 
 *
 * @author  bnevins
 * @version 
 */

public class Profiler 
{
	private Profiler() 
	{
    }
	/** Reset the global ProfilerImpl instance.
	 **/
	public static void reset()
	{
		profiler.reset(); 
	}
	/** Start timing an item.
	 **/
	public static void beginItem()
	{
		profiler.beginItem();
	}
	/** Start timing an item.
	 * @param desc - Descriptive text for the item 
	 */	
	public static void beginItem(String desc)
	{
		profiler.beginItem(desc);
	}
	/** Stop timing of the latest item
	 */
	public static void endItem()
	{
		profiler.endItem();
	}
	/** return a String report of all the timings
	 * @return  */	
	public static String report()
	{
		return profiler.toString();
	}
	
	////////////////////////////////////////////////////////////////////////////
	
	/**
	 * @param notUsed  */	
	public static void main(String[] notUsed)
	{
		try
		{
			profiler.beginItem("first item");
			Thread.sleep(3000);
			profiler.beginItem("second item here dude whoa yowser yowser");
			Thread.sleep(1500);
			profiler.endItem();
			profiler.endItem();
			System.out.println("" + profiler);
		}
		catch(Exception e)
		{
		}
	}
	
	static ProfilerImpl profiler = new ProfilerImpl();
}
