/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * FileSource.java
 *
 * Created on December 11, 2001, 12:46 AM
 */

package com.sun.enterprise.util.io;

import java.io.*;

/**
 *
 * @author  bnevins
 * @version 
 */
public class FileSource 
{
	public FileSource(File f) 
	{
		if(f == null)
			throw new IllegalArgumentException("null File argument.");
		else if(!f.exists())
			throw new IllegalArgumentException("File doesn't exist: " + FileUtils.safeGetCanonicalPath(f));
		
		if(f.isDirectory())
			isDir = true;
		else
			isDir = false;
		
		fileSource = f;
	}
	
	///////////////////////////////////////////////////////////////////////////

	public boolean exists()
	{
		return fileSource != null && fileSource.exists();
	}
	
	///////////////////////////////////////////////////////////////////////////

	public File getSource()
	{
		return fileSource;
	}
	
	///////////////////////////////////////////////////////////////////////////

	public File getFile()
	{
		return fileSource;
	}
	
	///////////////////////////////////////////////////////////////////////////

	public boolean isArchive()
	{
		return !isDir;
	}
	
	///////////////////////////////////////////////////////////////////////////

	public boolean isDirectory()
	{
		return isDir;
	}
	
	///////////////////////////////////////////////////////////////////////////

	public boolean isDir()
	{
		return isDirectory();
	}
	
	///////////////////////////////////////////////////////////////////////////

	public String toString()
	{
		if(fileSource == null)
			return "null FileSource";
	
		return FileUtils.safeGetCanonicalPath(fileSource);
	}
	
	///////////////////////////////////////////////////////////////////////////

	private File	fileSource	= null;
	private boolean	isDir		= false;
}
