/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * NativeIOException.java
 *
 * Created on April 14, 2003, 6:02 PM
 */

package com.sun.enterprise.util.io;

import java.io.IOException;

/**
 * An Exception that has a localized String for the error id returned by Native code
 * and the actual integer id value.
 * @author  bnevins
 */
public class NativeIOException extends IOException
{
	/**
	 * Constructs an instance of <code>NativeIOException</code> with the specified detail message.
	 * @param msg the detail message.
	 */
	public NativeIOException(String msg)
	{
		this(msg, -1);
	}
	/**
	 * Constructs an instance of <code>NativeIOException</code> with the specified detail message.
	 * @param msg the detail message.
	 * @param id the integer id returned by native code
	 */
	public NativeIOException(String msg, int id)
	{
		super(msg);
		resultID = id;
	}
	/**
	 * @return the error id returned by native code
	 */	
	public int getResultID()
	{
		return resultID;
	}
	
	private int resultID;
}
