/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package org.apache.tools.ant.taskdefs.optional.iplanet;

import org.apache.tools.ant.BuildException;

import java.util.Map;
import java.util.HashMap;

public class InstanceTask extends IasAdmin {
	private String action;

	private static final String ACTION_START   = "start";
	private static final String ACTION_STOP    = "stop";
	private static final String ACTION_RESTART = "restart";
	private static final String ACTION_CREATE  = "create";
	private static final String ACTION_DESTROY = "destroy";

	private static final Map ACTION_MAP = new HashMap(5);
	static {
		ACTION_MAP.put(ACTION_START, "start-instance");
		ACTION_MAP.put(ACTION_STOP, "stop-instance");
		ACTION_MAP.put(ACTION_RESTART, null);
		ACTION_MAP.put(ACTION_CREATE, "create-instance");
		ACTION_MAP.put(ACTION_DESTROY, "delete-instance");
	};

	public void setAction(String action) {
		this.action = action;
	}

	protected void checkConfiguration() throws BuildException {
		super.checkConfiguration();
	
		if (action == null) {
			String msg = "The action command must be specified.";
			throw new BuildException(msg, getLocation());
		}

		if (!ACTION_MAP.containsKey(action)) {

			String msg = "The action command (\"" + action + "\") is invalid.";
			throw new BuildException(msg, getLocation());
		}
	}

	protected void checkConfiguration(Server aServer) throws BuildException {
		super.checkConfiguration(aServer);
		if ((action.equals(ACTION_CREATE) || action.equals(ACTION_DESTROY)) &&
				(aServer.getInstance() == null)) {
			String msg = "When creating or destroying an application server "
							+ "instance, the \"instance\" attribute is required.";
			throw new BuildException(msg, getLocation());
		}
	}

	protected void execute(Server aServer) throws BuildException {
		if (action.equals(ACTION_RESTART)) {
			execute(ACTION_STOP, aServer);
			execute(ACTION_START, aServer);
		} else {
			execute(action, aServer);
		}
	}

	private void execute(String anAction, Server aServer) throws BuildException {
		String cmdString = (String) ACTION_MAP.get(anAction);
		cmdString +=aServer.getCommandParameters(false);
		if (anAction.equals(ACTION_CREATE)) {
			cmdString += " --instanceport " + aServer.getInstanceport();
		}
		if (aServer.getInstance() != null) {
			cmdString += " " + aServer.getInstance();
		}
		execIasCommand(cmdString);
	}
}