/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.ejb.base.sfsb.initialization;

import java.lang.reflect.Method;

import java.net.InetAddress;

import java.util.logging.Logger;
import java.util.logging.Level;

import com.sun.ejb.spi.sfsb.initialization.PersistenceStrategyBuilder;
import com.sun.ejb.spi.sfsb.initialization.SFSBContainerInitialization;
import com.sun.ejb.spi.sfsb.util.CheckpointPolicy;

import com.sun.ejb.base.sfsb.util.CheckpointPolicyImpl;
import com.sun.ejb.base.sfsb.util.ScrambledKeyGenerator;
import com.sun.ejb.base.sfsb.util.SimpleKeyGenerator;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.util.Utility;

import com.sun.logging.LogDomains;

import com.sun.ejb.base.container.util.CacheProperties;

/**
 * (Abstract)Base class for all the PersistenceStrategyBuilders.
 *  Any code that is common to both HADB and File StoreManagers
 *  can be put here.
 *
 * @author Mahesh Kannan
 */
public abstract class AbstractPersistenceStrategyBuilder
    implements PersistenceStrategyBuilder
{
    protected static Logger _logger =
	LogDomains.getLogger(LogDomains.EJB_LOGGER);

    protected SFSBContainerInitialization   container;
    protected EjbDescriptor		    descriptor;
    private int  removalGracePeriodInSeconds = 0;

    public AbstractPersistenceStrategyBuilder() {
    }
    
    public void initializePersistenceStrategy(
	SFSBContainerInitialization container, EjbDescriptor descriptor)
    {
	this.container = container;
	this.descriptor = descriptor;

	CacheProperties cacheProps = new CacheProperties(descriptor);
	int removalTimeout = cacheProps.getRemovalTimeoutInSeconds();
	if (removalTimeout > 0) {
	    this.removalGracePeriodInSeconds = removalTimeout / 2;
	}
	container.setRemovalGracePeriodInSeconds(removalGracePeriodInSeconds);
    }

    protected int getRemovalGracePeriodInSeconds() {
	return this.removalGracePeriodInSeconds;
    }

}  
