/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.ejb.base.stats;

import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.BoundedRangeStatistic;

import com.sun.enterprise.admin.monitor.stats.EJBCacheStats;
import com.sun.enterprise.admin.monitor.stats.CountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.BoundedRangeStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.MutableBoundedRangeStatisticImpl;

import com.sun.enterprise.admin.monitor.registry.MonitoringRegistry;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevelListener;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevel;
import com.sun.enterprise.admin.monitor.registry.MonitoringRegistrationException;

import com.sun.ejb.spi.stats.EJBCacheStatsProvider;

import java.util.logging.*;
import com.sun.enterprise.log.Log;
import com.sun.logging.*;

/**
 * A Class for providing stats for EJB Caches.
 *  Used by both Entity and Stateful Containers
 *
 * @author Mahesh Kannan
 */

public class EJBCacheStatsImpl
    extends StatsImpl
    implements com.sun.enterprise.admin.monitor.stats.EJBCacheStats
{
    private EJBCacheStatsProvider delegate;

    private MutableBoundedRangeStatisticImpl	cacheHits;
    private MutableBoundedRangeStatisticImpl	cacheMisses;
    private MutableBoundedRangeStatisticImpl	numBeans;
    private MutableCountStatisticImpl		expiredStat;
    private MutableCountStatisticImpl		passivationErrors;
    private MutableCountStatisticImpl		passivations;
    private MutableCountStatisticImpl		passivationSuccess;


    public EJBCacheStatsImpl(EJBCacheStatsProvider delegate) {
	this.delegate = delegate;

	initialize();
    }

    protected void initialize() {
	super.initialize("com.sun.enterprise.admin.monitor.stats.EJBCacheStats");

	cacheHits = new MutableBoundedRangeStatisticImpl(
		new BoundedRangeStatisticImpl("CacheHits"));
	cacheMisses = new MutableBoundedRangeStatisticImpl(
		new BoundedRangeStatisticImpl("CacheMisses"));
	numBeans = new MutableBoundedRangeStatisticImpl(
		new BoundedRangeStatisticImpl("NumBeansInCache",
		   "Count", 0, delegate.getMaxCacheSize(), 0));
	expiredStat = new MutableCountStatisticImpl(
		new CountStatisticImpl("NumExpiredSessionsRemoved"));
	passivationErrors = new MutableCountStatisticImpl(
		new CountStatisticImpl("NumPassivationErrors"));
	passivations = new MutableCountStatisticImpl(
		new CountStatisticImpl("NumPassivations"));
	passivationSuccess = new MutableCountStatisticImpl(
		new CountStatisticImpl("NumPassivationSuccess"));
    }

    public BoundedRangeStatistic getCacheHits(){
	cacheHits.setCount(delegate.getCacheHits());
	return (BoundedRangeStatistic) cacheHits.modifiableView();
    }

    public BoundedRangeStatistic getCacheMisses(){
	cacheMisses.setCount(delegate.getCacheMisses());
	return (BoundedRangeStatistic) cacheMisses.modifiableView();
    }

    public BoundedRangeStatistic getNumBeansInCache(){
	numBeans.setCount(delegate.getNumBeansInCache());
	return (BoundedRangeStatistic) numBeans.modifiableView();
    }

    public CountStatistic getNumExpiredSessionsRemoved(){
	expiredStat.setCount(delegate.getNumExpiredSessionsRemoved());
	return (CountStatistic) expiredStat.modifiableView();
    }

    public CountStatistic getNumPassivationErrors(){
	passivationErrors.setCount(delegate.getNumPassivationErrors());
	return (CountStatistic) passivationErrors.modifiableView();
    }

    public CountStatistic getNumPassivations(){
	passivations.setCount(delegate.getNumPassivations());
	return (CountStatistic) passivations.modifiableView();
    }

    public CountStatistic getNumPassivationSuccess() {
	passivationSuccess.setCount(delegate.getNumPassivationSuccess());
	return (CountStatistic) passivationSuccess.modifiableView();
    }

}
