/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.ejb.base.stats;

import javax.management.j2ee.statistics.EntityBeanStats;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.RangeStatistic;

import com.sun.enterprise.admin.monitor.stats.CountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.BoundedRangeStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.MutableBoundedRangeStatisticImpl;

import com.sun.enterprise.admin.monitor.registry.MonitoringRegistry;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevelListener;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevel;
import com.sun.enterprise.admin.monitor.registry.MonitoringRegistrationException;

import com.sun.ejb.spi.stats.EntityBeanStatsProvider;

import java.util.logging.*;
import com.sun.enterprise.log.Log;
import com.sun.logging.*;

/**
 * A Class for providing stats for Entity Container.
 *
 * @author Mahesh Kannan
 */

public class EntityBeanStatsImpl
    extends EJBStatsImpl
    implements javax.management.j2ee.statistics.EntityBeanStats
{
    protected EntityBeanStatsProvider		entityDelegate;

    private MutableBoundedRangeStatisticImpl	pooledCountStat;
    private MutableBoundedRangeStatisticImpl	readyCountStat;

    public EntityBeanStatsImpl(EntityBeanStatsProvider delegate) {
	super(delegate, "javax.management.j2ee.statistics.EntityBeanStats");
	this.entityDelegate = delegate;

	initStats();
    }

    private void initStats() {
	pooledCountStat = new MutableBoundedRangeStatisticImpl(
	    new BoundedRangeStatisticImpl("PooledCount",
		"Count", 0, entityDelegate.getMaxPoolSize(),
		entityDelegate.getSteadyPoolSize()));
	readyCountStat = new MutableBoundedRangeStatisticImpl(
	    new BoundedRangeStatisticImpl("ReadyCount",
		"Count", 0, entityDelegate.getMaxCacheSize(), 0));
    }

    public RangeStatistic getPooledCount() {
	pooledCountStat.setCount(entityDelegate.getPooledCount());
	return (RangeStatistic) pooledCountStat.modifiableView();
    }

    public RangeStatistic getReadyCount() {
	readyCountStat.setCount(entityDelegate.getReadyCount());
	return (RangeStatistic) readyCountStat.modifiableView();
    }

}
