/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.ejb.codegen;

/**
 * The class CmpCompilerException is a form of Throwable that indicates error 
 * conditions in CMP compilation during deployment. 
 *
 * @author Nazrul Islam
 * @since  JDK1.4
 */
public class CmpCompilerException extends Exception {

    /**
     * Constructs a new exception with null as its detail message.
     */
    public CmpCompilerException() { 
        super();
    }

    /**
     * Constructs a new exception with the specified detail message.
     *
     * @param    s    the detail message
     */
    public CmpCompilerException(String s) {
        super(s);
    }

    /**
     * Constructs a new exception with the specified cause and 
     * a detail message.
     *
     * @param    t    the cause
     */
    public CmpCompilerException(Throwable t) {
        super(t);
    }

    /**
     * Constructs a new exception with the specified detail message and cause.
     *
     * @param    msg    the detail message 
     * @param    t      the cause
     */
    public CmpCompilerException(String msg, Throwable t) {
        super(msg, t);
    }

}
