/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.ejb.codegen;

import java.io.File;
import com.sun.enterprise.deployment.EjbDescriptor;

/**
 * Helper class for ejbc generated class names.
 *
 * @author  Nazrul Islam
 * @since   JDK 1.4
 */
public class GeneratedNames {

    /**
     * Initializes the generated names based on the given 
     * deployment descriptor.
     * 
     * @param    desc    deployment descriptor
     */
    public GeneratedNames(EjbDescriptor desc) {
        // Set the file names for generated Home/Remote impl/tie/stubs

        // set EJBOBject Impl 
        ejbObjectImplClass = 
            desc.getEJBObjectImplClassName().replace('.', 
                                File.separatorChar) + ".class";
       
        // set EJBHome Impl 
        homeImplClass = 
            desc.getRemoteHomeImplClassName().replace('.', 
                                    File.separatorChar) + ".class";

        // Set EJBHome/EJBObject stub filenames
        homeStubClass = 
            getStubName(desc.getHomeClassName()).replace('.', 
                                    File.separatorChar) + ".class";
        remoteStubClass = 
            getStubName(desc.getRemoteClassName()).replace('.', 
                                    File.separatorChar) + ".class"; 
    }
     
    /**
     * Returns the stub classname for the given interface name
     *
     * @param    fullName    fully qualified name of the ejb home and obj impl
     */
    public static String getStubName(String fullName) {

        String className = fullName;
        String packageName = "";

        int lastDot = fullName.lastIndexOf('.');
        if (lastDot != -1) {
            className   = fullName.substring(lastDot+1, fullName.length());
            packageName = fullName.substring(0, lastDot+1);
        }

        String stubName = packageName + "_" + className + "_Stub";

		if(isSpecialPackage(fullName))
            stubName = ORG_OMG_STUB_PREFIX + stubName;

        return stubName;
    }

    public String getEjbObjectImplClass() {
        return ejbObjectImplClass;
    }

    public String getHomeImplClass() {
        return homeImplClass;
    }

    public String getHomeStubClass() {
        return homeStubClass;
    }

    public String getRemoteStubClass() {
        return remoteStubClass;
    }

	private static boolean isSpecialPackage(String name)
	{
		// these package names are magic.  RMIC puts any home/remote stubs
		// into a different directory in these cases.
		// 4845896  bnevins, April 2003
		
		// this is really an error.  But we have enough errors. Let's be forgiving
		// and not allow a NPE out of here...
		if(name == null)	
			return false;
		
		// Licensee bug 4959550 
		// if(name.startsWith("com.sun.") || name.startsWith("javax."))
		if(name.startsWith("javax."))
			return true;
		
		return false;
	}

	// ---- INSTANCE VARIABLES - PRIVATE ---------------------------------
    private String homeImplClass;  
    private String homeStubClass;
    private String remoteStubClass;
    private String ejbObjectImplClass;

    private static final String ORG_OMG_STUB_PREFIX  = "org.omg.stub.";
}
