/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.ejb.containers;

import java.lang.reflect.Method;
import java.io.*;
import java.rmi.RemoteException;

import javax.ejb.*;
import javax.transaction.*;

import javax.rmi.PortableRemoteObject;

import java.util.*;

import com.sun.ejb.*;
import com.sun.ejb.portable.ObjrefEnumeration;
import com.sun.enterprise.*;
import com.sun.enterprise.deployment.*;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.appverification.factory.AppVerification;

 /*
  * This class implements the Commit-Option C as described in
  * the EJB Specification.
  *
  * The CommitOptionC Container extends Entity Container and
  * hence all the life cycle management is still in Entitycontainer
  *
  * @author Mahesh Kannan
  */

public class CommitCEntityContainer
    extends EntityContainer
{
    /**
     * This constructor is called from the JarManager when a Jar is deployed.
     * @exception Exception on error
     */
    protected CommitCEntityContainer(EjbDescriptor desc, ClassLoader loader)
        throws Exception
    {
        super(desc, loader);
    }
    
    protected EntityContextImpl getReadyEJB(Invocation inv) {
        Object primaryKey = inv.ejbObject.getKey();
        return activateEJBFromPool(primaryKey, inv);
    }
    
    protected void createReadyStore(int cacheSize, int numberOfVictimsToSelect,
            float loadFactor, long idleTimeout)
    {
        readyStore = null;
    }
    
    protected void createEJBObjectStores(int cacheSize,
            int numberOfVictimsToSelect, long idleTimeout) throws Exception
    {
        super.defaultCacheEJBO = false;
        super.createEJBObjectStores(cacheSize, numberOfVictimsToSelect, idleTimeout);
    }
    
    // called from releaseContext, afterCompletion
    protected void addReadyEJB(EntityContextImpl context) {
        passivateAndPoolEJB(context);
    }
    
    protected void destroyReadyStoreOnUndeploy() {
        readyStore = null;
    }
    
    protected void removeContextFromReadyStore(Object primaryKey,
            EntityContextImpl context)
    {
        // There is nothing to remove as we don't have a readyStore
    }
    
}

