/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.ejb.containers;

/**
 * Implementation of the EJBHome interface.
 * This class is also the base class for all generated concrete ReadOnly
 * EJBHome implementations.
 * At deployment time, one instance of ReadOnlyEJBHomeImpl is created 
 * for each EJB class in a JAR that has a remote home. 
 *
 * @author Mahesh Kannan
 */

public abstract class ReadOnlyEJBHomeImpl
    extends EJBHomeImpl
    implements ReadOnlyEJBHome
{
    private ReadOnlyBeanContainer robContainer;

    public ReadOnlyEJBHomeImpl()
        throws java.rmi.RemoteException
    {
        super();
    }

    /** 
     * Called from ReadOnlyBeanContainer only.
     */
    final void setReadOnlyBeanContainer(ReadOnlyBeanContainer container) {
        this.robContainer = container;
    }


    /***********************************************/
    /** Implementation of ReadOnlyEJBHome methods **/
    /***********************************************/

    //Shouldn't be called. deprecated
    public com.sun.ejb.ReadOnlyBeanNotifier getReadOnlyBeanNotifier()
        throws java.rmi.RemoteException
    {
        throw new java.rmi.RemoteException("Internal ERROR: "
                + " getReadOnlyBeanNotifier() called");
    }

    public void _refresh_com_sun_ejb_containers_read_only_bean_(Object primaryKey)
        throws java.rmi.RemoteException
    {
        robContainer.setRefreshFlag(primaryKey);
    }

    public void _refresh_All() throws java.rmi.RemoteException
    {
        robContainer.refreshAll();
    }
}

