/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.ejb.containers;

import java.io.Serializable;
import java.util.Date;
import java.util.Collection;
import java.util.Set;

import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.CreateException;
import javax.ejb.FinderException;

/**
 *
 * @author Kenneth Saks
 */
public interface TimerLocalHome extends EJBLocalHome {

    TimerLocal create(String timerId,  
                      long containerId, String ownerId,
                      Object timedObjectPrimaryKey, 
                      Date initialExpiration, long intervalDuration, 
                      Serializable info) throws CreateException;

    TimerLocal findByPrimaryKey(TimerPrimaryKey timerId) throws FinderException;

    // 
    // Queries returning Timer Ids (TimerPrimaryKey)
    //

    Set selectTimerIdsByContainer(long containerId)
        throws FinderException;
    Set selectActiveTimerIdsByContainer(long containerId)
        throws FinderException;
    Set selectCancelledTimerIdsByContainer(long containerId)
        throws FinderException;    

    Set selectTimerIdsOwnedByThisServerByContainer(long containerId) 
        throws FinderException;
    Set selectActiveTimerIdsOwnedByThisServerByContainer(long containerId) 
        throws FinderException;
    Set selectCancelledTimerIdsOwnedByThisServerByContainer(long containerId)
        throws FinderException;

    Set selectAllTimerIdsOwnedByThisServer() throws FinderException; 
    Set selectAllActiveTimerIdsOwnedByThisServer() throws FinderException; 
    Set selectAllCancelledTimerIdsOwnedByThisServer() throws FinderException;

    Set selectAllTimerIdsOwnedBy(String owner) throws FinderException;
    Set selectAllActiveTimerIdsOwnedBy(String owner) throws FinderException;
    Set selectAllCancelledTimerIdsOwnedBy(String owner) throws FinderException;


    //
    // Queries returning Timer local objects
    //

    Set selectTimersByContainer(long containerId)
        throws FinderException;
    Set selectActiveTimersByContainer(long containerId)
        throws FinderException;
    Set selectCancelledTimersByContainer(long containerId)
        throws FinderException;    

    Set selectTimersOwnedByThisServerByContainer(long containerId) 
        throws FinderException;
    Set selectActiveTimersOwnedByThisServerByContainer(long containerId) 
        throws FinderException;
    Set selectCancelledTimersOwnedByThisServerByContainer(long containerId)
        throws FinderException;

    Set selectAllTimersOwnedByThisServer() throws FinderException; 
    Set selectAllActiveTimersOwnedByThisServer() throws FinderException; 
    Set selectAllCancelledTimersOwnedByThisServer() throws FinderException;

    Set selectAllTimersOwnedBy(String owner) throws FinderException;
    Set selectAllActiveTimersOwnedBy(String owner) throws FinderException;
    Set selectAllCancelledTimersOwnedBy(String owner) throws FinderException;


    //
    // Queries returning counts
    //

    int selectCountTimersByContainer(long containerId)
        throws FinderException;
    int selectCountActiveTimersByContainer(long containerId)
        throws FinderException;
    int selectCountCancelledTimersByContainer(long containerId)
        throws FinderException;    

    int selectCountTimersOwnedByThisServerByContainer(long containerId) 
        throws FinderException;
    int selectCountActiveTimersOwnedByThisServerByContainer(long containerId) 
        throws FinderException;
    int selectCountCancelledTimersOwnedByThisServerByContainer(long containerId)
        throws FinderException;

    int selectCountAllTimersOwnedByThisServer() 
        throws FinderException; 
    int selectCountAllActiveTimersOwnedByThisServer() 
        throws FinderException; 
    int selectCountAllCancelledTimersOwnedByThisServer() 
        throws FinderException;

    int selectCountAllTimersOwnedBy(String owner) 
        throws FinderException;
    int selectCountAllActiveTimersOwnedBy(String owner) 
        throws FinderException;
    int selectCountAllCancelledTimersOwnedBy(String owner) 
        throws FinderException;



    // Perform health check on timer database
    boolean checkStatus(String resourceJndiName, boolean checkDatabase);

}
