/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.ejb.containers.interceptors;

import java.lang.reflect.Method;
import javax.interceptor.InvocationContext;
import javax.ejb.EJBContext;

import com.sun.ejb.EJBUtils;
import com.sun.ejb.Invocation.InterceptorChain;
import com.sun.ejb.containers.EJBContextImpl;

import java.util.Map;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;


/**
 * Concrete InvocationContext implementation passed to callback methods 
 * defined in interceptor classes.
 */
public class CallbackInvocationContext implements InvocationContext {

    private EJBContextImpl ejbContext;
    private Map contextData;
    private int callbackIndex = 0;
    private CallbackChainImpl callbackChain;

    public CallbackInvocationContext(EJBContextImpl ejbContextImpl,
                                     CallbackChainImpl chain) {
        ejbContext = ejbContextImpl;
        callbackChain = chain;
    }

    public Object getTarget() {
        return ejbContext.getEJB();
    }

    public Method getMethod() {
        return null;
    }
    
    public Object[] getParameters() {
        throw new IllegalStateException("not applicable to Callback methods");
    }

    public void setParameters(Object[] params) {
        throw new IllegalStateException("not applicable to Callback methods");
    }

    public EJBContext getEJBContext() {
        return ejbContext;
    }

    public Map<String, Object> getContextData() {
        if( contextData == null ) {
            contextData = new HashMap();
        }

        return contextData;
    }
    
    public Object proceed() throws Exception {
        try {
            callbackIndex++;
            return callbackChain.invokeNext(callbackIndex, this);
        } catch (Exception ex) {
            throw ex;
        } catch (Throwable th) {
            throw new Exception(th);
        }
    }

}

