/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.ejb.portable;

import java.io.*;
import java.rmi.RemoteException;

import javax.ejb.*;
import javax.ejb.spi.HandleDelegate;
import javax.naming.*;


/**
 * A portable implementation of HomeHandle using the 
 * HandleDelegate SPI.
 * This class can potentially be instantiated in another vendor's container
 * so it must not refer to any non-portable RI-specific classes.
 *
 */

public final class HomeHandleImpl implements HomeHandle, Serializable
{
    private EJBHome ejbHome;

    // This constructor will only be used by the EJB container in the RI.
    public HomeHandleImpl(EJBHome ejbHome)
    {
	this.ejbHome = ejbHome;
    }

    // This is the public API from javax.ejb.HomeHandle
    public EJBHome getEJBHome() throws RemoteException
    {
	return ejbHome;
    }

    private void writeObject(ObjectOutputStream ostream)
	throws IOException
    {
	HandleDelegate handleDelegate;
	try {	    
	    handleDelegate = HandleDelegateUtil.getHandleDelegate();
	} catch ( NamingException ne ) {                                   
            throw new EJBException("Unable to lookup HandleDelegate", ne);
        }
        handleDelegate.writeEJBHome(ejbHome, ostream);
    }

    private void readObject(ObjectInputStream istream)
	throws IOException, ClassNotFoundException
    {
	HandleDelegate handleDelegate;
	try {	   
	    handleDelegate = HandleDelegateUtil.getHandleDelegate();
	} catch ( NamingException ne ) {                        
            throw new EJBException("Unable to lookup HandleDelegate", ne);
        }
        ejbHome = handleDelegate.readEJBHome(istream);
    }
}
