/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.ejb.spi.sfsb.store;

import java.util.Map;

import com.sun.ejb.spi.stats.MonitorableSFSBStoreManager;

/**
 * Interface that will be used by the SFSB container to interact
 *  with a session store.
 *
 * Note that there is a one-one association between Container and Store
 *
 * @author  Mahesh Kannan
 */
public interface SFSBStoreManager {
    
    /**
     * Store session data in this beanState
     * This method used only for checkpointing; use passivateSave for passivating
     */
    public void checkpointSave(SFSBBeanState beanState)
        throws SFSBStoreManagerException;    
      
    /**
     * A Factory method to create a SFSBBeanState. The StoreManager
     *	is responsible for filling the SFSBBeanState with the 
     *	correct ClusterId, containerId and SFSBStoreManager
     */
    public SFSBBeanState createSFSBBeanState(Object sessionId,
	    long lastAccess, boolean isNew, byte[] state);

    /**
     *Get the SFSBStoreManagerMonitor
     */
    public MonitorableSFSBStoreManager getMonitorableSFSBStoreManager();

    /**
     * Return the SFSBBeanState containing 
     * the stored session data identified by this sessionKey
     * @return the SFSBBeanState containing stored session data 
     * or null if the sessionKey is invalid / removed
     */ 
    public SFSBBeanState getState(Object sessionKey)
        throws SFSBStoreManagerException;    
     
    /**
     * Called from the Container during container creation
     */
    public void initSessionStore(Map storeEnv)
        throws SFSBStoreManagerException;    
    
    /**
     * Store session data in this beanState
     * This method used only for passivation; use checkpointSave for checkpointing
     */
    public void passivateSave(SFSBBeanState beanState)
        throws SFSBStoreManagerException; 
    
    /**
     * Remove the session data identified by this sessionKey
     */
    public void remove(Object sessionKey)
        throws SFSBStoreManagerException; 
    
    /**
     * Remove all session data for this container
     * called during undeployment
     */
    public void removeAll()
        throws SFSBStoreManagerException;    
      
    /**
     * Remove all the idle/expired session data 
     * that are idle for idleTimeoutInSeconds (passed during initSessionStore())
     */
    public int removeExpiredSessions()
        throws SFSBStoreManagerException;    
      
    /**
     * Called during shutdown of instance
     */
    public void shutdown()
        throws SFSBStoreManagerException;

    /**
     * update only the lastAccessTime to the value time
     * Used when the session has been accessed as well
     * as periodically to keep session alive
     */
    public void updateLastAccessTime(Object sessionKey, long time)
        throws SFSBStoreManagerException;     
    
}
