/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.ejb.spi.stats;

/**
 * An interface that allows monitoring of an SFSBStoreManager implementation
 *
 * @author Mahesh Kannan
 */

public interface MonitorableSFSBStoreManager
    extends StatsProvider
{

    /**
     * Returns the number of passivated / checkpointed sessions in the store
     *	Note that this includes the sessions passivated / checkpointed by
     *	ohter store maangers in the cluster
     */
    public long getCurrentStoreSize();


    /**
     * Notification that the monitoringLevel is either turned off (false)
     *	OR tuened on (true).
     * @param monitoringOn true if monitoring is either HIGH / LOW
     *	false otherwise
     */
    public void monitoringLevelChanged(boolean monitoringOn);

}
