/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.common;

//Admin imports
import com.sun.enterprise.admin.util.IPatternMatcher;
import com.sun.enterprise.admin.util.RegExpMatcher;
import com.sun.enterprise.admin.util.GeneralPatternMatcher;
import com.sun.enterprise.admin.util.Logger;

// i18n import 
import com.sun.enterprise.admin.util.SOMLocalStringsManager;

public class CombinedPatternMatcher implements IPatternMatcher
{
	private String          mPattern		= null;
	private String          mTestString		= null;
	private IPatternMatcher mRealMatcher    = null;

	// i18n SOMLocalStringsManager
	private static SOMLocalStringsManager localizedStrMgr =
		SOMLocalStringsManager.getManager( CombinedPatternMatcher.class );

	/** 
		Creates new CombinedPatternMatcher with pattern string and
		string on which the patten has to be matched. None of the
		strings may be null.
		
		@param patternString the Pattern string.
		@param testString the string on which pattern should be applied.
	*/
    
	public CombinedPatternMatcher(String patternString, String testString)
	{
        if (patternString == null || testString == null)
        {
			String msg = localizedStrMgr.getString( "admin.common.combinedpattermatcher_null_arg" );
            throw new IllegalArgumentException( msg );
        }
		mPattern	= patternString;
		mTestString	= testString;
        if (isJDK14())
        {
//            Logger.log("using the jdk 1.4 regular expression facility");
            mPattern = translateFromJMXToJDK14(patternString);
            mRealMatcher = new RegExpMatcher(mPattern, testString);
        }
        else
        {
//            Logger.log("using pattern matcher without jdk 1.4");
            mRealMatcher = new GeneralPatternMatcher(patternString, testString);
        }
    }

	public boolean matches()
	{
        return ( mRealMatcher.matches() );
	}
	
	public boolean isJDK14()
	{
		String javaSpecVersion = System.getProperty("java.specification.version");
		
		return ( javaSpecVersion.startsWith("1.4") );
	}
    
    private String translateFromJMXToJDK14(String aString)
    {
        String dotEscpapedString    = escapeDots(aString);
        String starReplacedString   = insertDotBeforeStar(dotEscpapedString);
        String qmReplacedString     = insertDotBeforeQM(starReplacedString);
        return ( qmReplacedString );
    }
    
    private String escapeDots(String aString)
    {
        char escape      = Tokens.kEscapeChar;
        char dot         = Tokens.kDelimiterChar;
        return ( insertCharBefore(aString, escape, dot) );
    }
    private String insertDotBeforeStar(String aString)
    {
        char dot        = Tokens.kDelimiterChar;
        char star       = Tokens.kWildCardChar;
        
        return ( insertCharBefore(aString, dot, star) );
    }
    private String insertDotBeforeQM(String aString)
    {
        char dot        = Tokens.kDelimiterChar;
        char qm         = ObjectNames.kSingleMatchChar;
        
        return ( insertCharBefore(aString, dot, qm) );
    }
    private String insertCharBefore(String aString, char insChar, char beforeChar)
    {
        StringBuffer    destBuffer  = new StringBuffer();
        char[]          srcArray    = aString.toCharArray();
        for (int i = 0 ; i < srcArray.length ; i++)
        {
            char ch = srcArray[i];
            if (ch == beforeChar)
            {
                destBuffer.append(insChar);
            }
            destBuffer.append(ch);
        }
        return ( destBuffer.toString() );
    }
}
