/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.common;

import java.io.File;
import java.io.IOException;

/*
 * FileTransfer.java
 *
 */

/** Interface to upload & download a given file to the server.
 */
public interface FileTransfer {
     
    /** uploads the given file to the server running at the host:port with
     * authentication. Assumes jmx-remote with s1ashttp protocol.
     * @param filePath the absolute path to the file to be uploaded
     * @throws IOException for IO related exceptions
     * @return The full path of the uploaded file
     */    
    public String uploadFile(String filePath) throws IOException ;
           
   /**
     *  Exports the Client stub jar to the given location.
     *  @param appName The name of the application or module.
     *  @param destDir The directory into which the stub jar file 
     *  should be exported.
     *  @return Returns the absolute location to the exported jar file.
     * @throws IOException for IO related exceptions
     */
    public String downloadClientStubs(String  appName, String  destDir) throws IOException;

    /**
     * downloads file to the given location.
     * @param filePath the absolute path to the file to be downloaded
     *  @param destDir The directory into which the stub jar file 
     *  should be exported.
     *  @return Returns the absolute location to the exported jar file.
     * @throws IOException for IO related exceptions
     */
    public String downloadFile(String filePath, String destinationDirPath) throws IOException;

    /**
     * Downloads file to the given location. This method supports multiple
     * distributed clients.
     *
     * @param filePath the absolute path to the file to be downloaded
     * @param destPath local file path where file should be downloaded
     *
     * @return the absolute location to the downloaded jar file
     *
     * @throws IOException for IO related exceptions
     */
    public String mcDownloadFile(String filePath, File destPath) 
        throws IOException;

}
