/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.common.domains.registry;
import java.util.HashSet;
import java.util.Collection;
/**
 * This class represents a collection of {@link ContactData}
 * elements. It is a set that guarantees that its elements are
 * instances of {@link ContactData}
 *
 * @author <a href="mailto:toby.h.ferguson@sun.com">Toby H Ferguson</a>
 * @version 1.0
 */
public class ContactDataSet extends HashSet
{

  public ContactDataSet(){
	super();
  }


	  /**
		 Construct a new instance, adding all the members from the
		 given collection.
		 <p>
		 Precondition - all members of the collection are instances of
		 the {@link ContactData} class
		 <p>
		 postcondition - the returned instance contains all the
		 members of the given collection, and only those members
		 @param c the given collection
		 @throws NullPointerException if c is null
		 @throws ClassCastException if one of the members of c is not
		 an instance of the {@link ContactData} class
	  */
  public ContactDataSet(Collection c) throws NullPointerException, ClassCastException{
	super(c);
  }

  public ContactDataSet(int initialCapacity){
	super(initialCapacity);
  }

  public ContactDataSet(int initialCapacity, float loadFactor){
	super(initialCapacity, loadFactor);
  }

	  /**
		 Add the given object to the receiver.
		 <p>
		 precondition - the given object is an instance of the {@link
		 ContactData} class
		 <p>
		 postcondition - the receiver contains the given object
		 @param o the object to be added
		 @return true iff the receiver changed as a result of adding
		 this object
		 @throws NullPointerException if the object is null
		 @throws ClassCastException if the object is not an instance
		 of {@link ContactData} class
	  */
  public boolean add(Object o) throws NullPointerException, ClassCastException{
	return super.add((ContactData) o);
  }
  
}
