/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.event;

import com.sun.enterprise.admin.event.AdminEventListener;

/**
 * Listener interface to handle auth realm events.
 */
public interface AuthRealmEventListener extends AdminEventListener {

    /**
     * New auth realm created.
     * It is called whenever a AuthRealmEvent with action of
     * AuthRealmEvent.ACTION_CREATE is received.
     * @throws AdminEventListenerException when the listener is unable to
     *         process the event.
     */
    public void authRealmCreated(AuthRealmEvent event)
             throws AdminEventListenerException;

    /**
     * Auth realm deleted.
     * It is called whenever a AuthRealmEvent with action of
     * AuthRealmEvent.ACTION_DELETE is received.
     * @throws AdminEventListenerException when the listener is unable to
     *         process the event.
     */
    public void authRealmDeleted(AuthRealmEvent event)
             throws AdminEventListenerException;

    /**
     * Auth realm updated (attributes change).
     * It is called whenever a AuthRealmEvent with action of
     * AuthRealmEvent.ACTION_UPDATE is received.
     * @throws AdminEventListenerException when the listener is unable to
     *         process the event.
     */
    public void authRealmUpdated(AuthRealmEvent event)
             throws AdminEventListenerException;

}
