/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.event;


/**
 * ClusterEvent - emitted by DAS to send requests GMSClientMBean and any
 * other listeners of type ClusterEventListener
 *
 * @author <a href=mailto:shreedhar.ganapathy@sun.com>Shreedhar Ganapathy</a>
 *         Date: Aug 16, 2005
 * @version $Revision: 1.2 $
 */
public class ClusterEvent extends ElementChangeEvent{

    public static final String eventType = ClusterEvent.class.getName();
    public ClusterEvent (
            String instance, int actionCode, String elementId )
    {
        super( instance, eventType, actionCode, elementId );
        System.out.println("ClusterChangeEvent: instance="+instance+
                           ":eventtype="+eventType+":actionCode="+actionCode+
                           ":elementID="+elementId);

    }
}
