/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.admin.event;

/**
 * LogLevelChangeEvent is used to represent change in the log level for
 * a module. Log levels and modules are configured in the configuration
 * file element module-log-levels.
 */
public class LogLevelChangeEvent extends AdminEvent {

    /**
     * Event type
     */
    static final String eventType = LogLevelChangeEvent.class.getName();

    /**
     * Logger module name
     */
    private String moduleName;
 
    /**
     * Old log level
     */
    private String oldLogLevel;

    /**
     * New log level
     */
    private String newLogLevel;

    /** 
     * true when this event represents property changes in the 
     * module-log-level element
     */
    private boolean propertyChanged = false;

    /**
     * name of the modified property
     */
    private String modifiedPropertyName = null;

    /**
     * Creates a new instance of LogLevelChangeEvent
     * @param instanceName the server instance affected by the change
     */
    public LogLevelChangeEvent(String instanceName) {
        this(eventType, instanceName);
    }

    /**
     * Creates a new instance of LogLevelChangeEvent
     * @eventType type of the event
     * @param instanceName the server instance affected by the change
     */
    protected LogLevelChangeEvent(String eventType, String instanceName) {
        super(eventType, instanceName);
    }

    /**
     * Get name of the module for which log level has changed. The name
     * of the module is defined in the dtd for configuration.
     */
    public String getModuleName() {
        return moduleName;
    }

    /**
     * Set module name.
     * @param moduleName name of the module for which the event is being created
     */
    void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    /**
     * Get old log level for the module returned by method getModuleName().
     * The log levels are defined in dtd for configuration
     */
    public String getOldLogLevel() {
        return oldLogLevel;
    }

    /**
     * Set old log level
     */
    void setOldLogLevel(String oldLevel) {
        oldLogLevel = oldLevel;
    }

    /**
     * Get new log level for the module returned by method getModuleName().
     * The log levels are defined in the dtd for configuration
     */
    public String getNewLogLevel() {
        return newLogLevel;
    }

    /**
     * Set new log level
     */
    void setNewLogLevel(String newLevel) {
        this.newLogLevel = newLevel;
    }
    
    /**
     * Returns true when propery changed for module-log-levels.
     * 
     * @return  true when property changed for module-log-levels
     */
    public boolean isPropertyChanged() {
        return this.propertyChanged;
    }

    /**
     * Sets the property change flag for module-log-levels.
     * 
     * @param  tf   val for property change flag
     */
    void setPropertyChanged(boolean tf) {
        this.propertyChanged = tf;
    }

    /**
     * Returns the name of the modified property when isPropertyChanged is true.
     * @return  name of the modified property or null
     */
    public String getPropertyName() {
        return this.modifiedPropertyName;
    }

    /**
     * Sets the name of the modified property.
     * @param  name  name of the modified property
     */
    void setPropertyName(String name) {
        this.modifiedPropertyName = name;
    }
}
