/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.admin.event;

/**
 * MonitoringLevelChangeEvent is used to represent change in the Monitoring
 * level for a component. Monitoring levels and components are configured in
 * the configuration file element monitoring-service.
 */
public class MonitoringLevelChangeEvent extends AdminEvent {

    /**
     * Event type
     */
    static final String eventType = MonitoringLevelChangeEvent.class.getName();

    /**
     * Monitored component name
     */
    private String componentName;
 
    /**
     * Old monitoring level
     */
    private String oldMonitoringLevel;

    /**
     * New monitoring level
     */
    private String newMonitoringLevel;

    /**
     * Creates a new instance of MonitoringLevelChangeEvent
     * @param instanceName the server instance affected by the change
     */
    public MonitoringLevelChangeEvent(String instanceName) {
        this(eventType, instanceName);
    }

    /**
     * Creates a new instance of MonitoringLevelChangeEvent
     * @eventType type of the event
     * @param instanceName the server instance affected by the change
     */
    protected MonitoringLevelChangeEvent(String eventType, String instanceName) {
        super(eventType, instanceName);
    }

    /**
     * Get name of the component for which Monitoring level has changed. The name
     * of the component is defined in the dtd for configuration.
     */
    public String getComponentName() {
        return componentName;
    }

    /**
     * Set component name.
     * @param componentName name of the component for which the event is being created
     */
    void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    /**
     * Get old monitoring level for the component returned by method
     * getComponentName(). The monitoring levels are defined in dtd for
     * configuration
     */
    public String getOldMonitoringLevel() {
        return oldMonitoringLevel;
    }

    /**
     * Set old Monitoring level
     */
    void setOldMonitoringLevel(String oldLevel) {
        oldMonitoringLevel = oldLevel;
    }

    /**
     * Get new monitoring level for the component returned by method
     * getComponentName(). The monitoring levels are defined in the dtd for
     * configuration.
     */
    public String getNewMonitoringLevel() {
        return newMonitoringLevel;
    }

    /**
     * Set new monitoring level
     */
    void setNewMonitoringLevel(String newLevel) {
        this.newMonitoringLevel = newLevel;
    }
    
}
