/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/**
 * PROPRIETARY/CONFIDENTIAL.  Use of this product is subject to license terms.
 *
 * Copyright 2001-2002 by iPlanet/Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 */
package com.sun.enterprise.admin.monitor;

import java.util.Map;
import java.util.Set;

/**
 * IMonitorable interface defines behaviour exhibited by any component
 * (service) that wants to expose some of its internal state to the
 * monitoring clients (HTML gui, command-line administration or other
 * third party tools built over command-line admin utility).
 */
public interface IMonitorable {

    /**
     * Start monitoring on this component. This will be called when monitoring
     * is enabled on this component (or the group containing this component)
     * through user interface.
     * @see stopMonitoring
     */
    public void startMonitoring();

    /**
     * Stop monitoring on this component. Called when monitoring is disabled on
     * user interface.
     */
    public void stopMonitoring();

    /**
     * Get value of specified monitored attribute.
     * @param monitorAttributeName name of the monitored attribute
     * @return value of the specified monitored attribute
     */
    public Object getMonitoredAttributeValue(String monitorAttributeName);

    /**
     * Get values of specified monitored attributes. This method returns a
     * map of monitored attribute names and their corresponding values.
     *
     * @param monitorAttributeNameSet set of monitored attribute names
     *
     * @return map of attribute names and their values
     */
    public Map getMonitoredAttributeValues(Set monitorAttributeNameSet);

    /**
     * Get a map of monitored attribute names and their types. The keys in
     * the map are names of the attribute and the values are their types. The
     * type value are instances of class
     * com.iplanet.ias.monitor.type.MonitoredAttributeType (or its sub-classes)
     *
     * @return map of names and types of all monitored attributes
     */
    public Map getMonitoringMetaData();
}
