/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * TraceEvent.java
 *
 */

package com.sun.enterprise.admin.selfmanagement.event;

import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationListener;
import javax.management.NotificationFilter;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.management.MalformedObjectNameException;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.logging.Logger;
import java.util.logging.Level;
import com.sun.logging.LogDomains;

import static com.sun.appserv.management.event.TraceEventHelper.*;



/**
 *
 * @author Sun Micro Systems, Inc
 */
public class TraceEvent implements Event {
    
    private static Logger _logger = LogDomains.getLogger(LogDomains.SELF_MANAGEMENT_LOGGER);
    private static StringManager sm = StringManager.getManager(TraceEvent.class);
    
    public TraceEvent(String type, TraceEventNotificationFilter lfilter, String description) {
        this.type = type;
        this.lfilter = lfilter;
        if (description != null)
            this.description = description;
        else
            this.description = defaultDescription;
    }
    
    public ObjectName getObjectName() {
        return objName;
    }
    
    
    public String getType() {
        return type;
    }
    
    public NotificationFilter getNotificationFilter( ){
        return lfilter;
    }
    
    public String getDescription() {
        return description;
    }
    
    public void destroy() {
        // do nothing
    }
    
    static ObjectName getTraceImplObjectName() {
        if (objName != null)
            return objName;
        try {
            objName =  new ObjectName( DOMAIN_NAME,DEFAULT_KEY, "trace");
        }catch (MalformedObjectNameException mex) {
            _logger.log(Level.WARNING,"smgt.internal_error", mex);
        }
        return objName;
    }

    public static boolean isValidType(String type) {
        if ("*".equals(type) || REQUEST_START.equals(type) ||
           REQUEST_END.equals(type) || WEB_COMPONENT_METHOD_ENTRY.equals(type) ||
           WEB_COMPONENT_METHOD_EXIT.equals(type) || EJB_COMPONENT_METHOD_ENTRY.equals(type) || 
           EJB_COMPONENT_METHOD_EXIT.equals(type) ) {
            return true;
        }
        return false;
    }
    
    private static ObjectName objName = null;
    private static String defaultDescription =
            sm.getString("selfmgmt_event.trace_event_description");
    private TraceEventNotificationFilter lfilter = null;
    private String description = null;
    private String type = null;

    /**
     * event types
    public static final String REQUEST_START = "trace.request_start";
    public static final String REQUEST_END = "trace.request_end";
    public static final String WEB_COMPONENT_METHOD_ENTRY = "trace.web_component_method_entry";
    public static final String WEB_COMPONENT_METHOD_EXIT = "trace.web_component_method_exit";
    public static final String EJB_COMPONENT_METHOD_ENTRY = "trace.ejb_component_method_entry";
    public static final String EJB_COMPONENT_METHOD_EXIT = "trace.ejb_component_method_exit";
     */
                                                                                                                                               

}
