/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.server.core;

import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.Collections;
import java.util.logging.Logger;
import java.util.logging.Level;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.io.IOException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
//import javax.management.MBeanServerFactory;
import com.sun.enterprise.admin.common.MBeanServerFactory;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXAuthenticator;

import com.sun.enterprise.admin.jmx.remote.DefaultConfiguration;
import com.sun.enterprise.admin.server.core.jmx.auth.ASJMXAuthenticator;
import com.sun.enterprise.admin.server.core.jmx.auth.ASLoginDriverImpl;

import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RMIClientSocketFactory;
import javax.rmi.ssl.SslRMIClientSocketFactory;

import com.sun.enterprise.admin.common.constant.AdminConstants;
import com.sun.appserv.server.ServerLifecycle;
import com.sun.appserv.server.ServerLifecycleException;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.config.serverbeans.JmxConnector;
import com.sun.enterprise.config.serverbeans.AdminService;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.server.pluggable.PluggableFeatureFactory;
import com.sun.enterprise.util.i18n.StringManager;

import javax.rmi.ssl.SslRMIClientSocketFactory;
import com.sun.enterprise.util.SystemPropertyConstants;
/* Following classes come from /m/jws/jmx-remote which gets built before
 * /m/jws/appserv-core */
/* start */
import com.sun.enterprise.admin.jmx.remote.server.rmi.JmxConnectorServerDriver;
import com.sun.enterprise.admin.jmx.remote.server.rmi.RemoteJmxProtocol;
/* end */
import com.sun.enterprise.admin.server.core.jmx.nonssl.RMIMultiHomedServerSocketFactory;
import com.sun.enterprise.admin.server.core.jmx.ssl.AdminSslServerSocketFactory;
import com.sun.enterprise.admin.server.core.jmx.ssl.AsTlsClientEnvSetter;
import com.sun.appserv.management.client.AdminRMISSLClientSocketFactory; /* From MBean API */
import javax.rmi.ssl.SslRMIServerSocketFactory;
/**
 *
 * @author  kedar
 */
public class JmxConnectorLifecycle implements ServerLifecycle {

    public static final Logger sLogger =
    Logger.getLogger(AdminConstants.kLoggerName);
    private static final StringManager sm = StringManager.getManager(JmxConnectorLifecycle.class);
    private ServerContext initContext = null;
    private JmxConnector connectorConfig = null;
    private JMXConnectorServer cs = null;
    private JMXConnectorServer jconsolecs = null;
    private JmxConnectorServerDriver driver;
    private boolean isEnabled = false;
    /** Creates a new instance of JmxConnectorLifecycle.
     */
    public JmxConnectorLifecycle() {
        sLogger.log(Level.FINE, "rjmx.lc.init");
    }

    public void onInitialization(ServerContext sc) throws ServerLifecycleException {
        try {
            initContext = sc;
            initConnectorConfig();
            handleIsEnabled(connectorConfig.getPort());
            handleSupportedProtocol();
            if (isEnabled) {
                driver = new JmxConnectorServerDriver();
                configureJmxConnectorServerDriver();
            }
        }
        catch(Exception e) {
            throw new ServerLifecycleException(e.getMessage(), e);
        }
    }

    public void onStartup(ServerContext sc) throws ServerLifecycleException {
        setupClientSide();
        try {
            if (isEnabled) {
                this.cs = driver.startConnectorServer();
                this.jconsolecs = driver.startJconsoleConnectorServer();
            }
            else {
                final String msg = "JmxConnectorLifeCycle.onStartup: Connector Server not enabled at port: " + connectorConfig.getPort();
                sLogger.fine(msg);
            }
        }
        catch (Exception e) {
            throw new ServerLifecycleException(e.getMessage(), e);
        }
    }

    public void onReady(ServerContext sc) throws ServerLifecycleException {
    }
    public void onShutdown() throws ServerLifecycleException {
        try {
            if (isEnabled) {
                driver.stopConnectorServer(cs);
                driver.stopConnectorServer(jconsolecs);
            }
            else {
                final String msg = "JmxConnectorLifeCycle.onShutdown: Connector Server not enabled at port: " + connectorConfig.getPort() + ", its shutdown is not required";
                sLogger.fine(msg);
            }
        }
        catch (final Exception e) {
            throw new ServerLifecycleException(e.getMessage());
        }
    }

    private MBeanServer getAssociatedMBS() {
        /*
        final String returnAllMBS = null;
        final ArrayList list = MBeanServerFactory.findMBeanServer(returnAllMBS);
        if (list.isEmpty())
                throw new RuntimeException("Initialize the MBeanServers first...");
        return (MBeanServer)list.get(0); //for now
         */
        return ( MBeanServerFactory.getMBeanServer() );
    }

    private Map getEnvironment() {
        final Map env = new HashMap();
        return ( env );
    }

    public void onTermination() throws ServerLifecycleException {
    }

    private void initConnectorConfig() throws ConfigException {
        //This is the AdminService config bean
        AdminService as = ServerBeansFactory.getConfigBean(initContext.getConfigContext()).
                  getAdminService();
        connectorConfig = as.getJmxConnectorByName(as.getSystemJmxConnectorName());
        if (connectorConfig.isEnabled()) {
            this.isEnabled = true;
        }
    }
    
    private JMXAuthenticator createJMXAuthenticator() {
        final ASJMXAuthenticator authenticator = new ASJMXAuthenticator();
        // TODO: If domain.xml is not present, can not configure authentication        
        authenticator.setRealmName(connectorConfig.getAuthRealmName());        
        authenticator.setLoginDriver(new ASLoginDriverImpl());
        return authenticator;
    }

    private void configureJmxConnectorServerDriver() throws ServerLifecycleException {        
        driver.setAuthentication(true);
        driver.setAuthenticator(createJMXAuthenticator());        
        driver.setLogger(this.sLogger);
        driver.setMBeanServer(this.getAssociatedMBS());
        driver.setRmiRegistrySecureFlag(new Boolean(System.getProperty(RmiTweaks.SECURE_RMI_REGISTRY)).booleanValue());
        try {
            driver.setProtocol(RemoteJmxProtocol.instance(connectorConfig.getProtocol()));
            driver.setPort(Integer.parseInt(connectorConfig.getPort()));
            handleSsl();
        }
        catch (final Exception e) {
            throw new ServerLifecycleException(e.getMessage());
        }
    }      
    
    /** Handles the enabled flag on system-jmx-connector. On PE, it is okay that this
     *  flag is set to false. But for SE/EE, it has to be true as the inter server 
     *  communication depends on it.
     */
    private void handleIsEnabled(final String port) throws ServerLifecycleException {
        /* Implementation note: This could have been handled using the Pluggable
         * Feature Factory, but since there isn't much pluggable behavior, I am going to
         * rely on the system property. In general, this should not be done.
         */
        if (isEE() && !isEnabled) {
            //EE and not enabled is not fine
            final String msg = sm.getString("rjmx.lc.disabled_ee_na", port);
            throw new ServerLifecycleException(msg);
        }
        if (!isEE() && !isEnabled) {
            //PE and not enabled is fine - log and move on
            sLogger.log(Level.INFO, "rjmx.lc.not_enabled", port);
        }
        //other 2 cases are implicitly handled
    }
    
    private boolean isEE() {
        boolean isEE = false;
        final String eepffc = "com.sun.enterprise.ee.server.pluggable.EEPluggableFeatureImpl";
        final String pn = PluggableFeatureFactory.PLUGGABLE_FEATURES_PROPERTY_NAME;
        final String pv = System.getProperty(pn);
        if (eepffc.equals(pv)) {
            isEE = true;
        }
        return ( isEE );
    }
    private void handleSupportedProtocol() throws ServerLifecycleException {
        final String pfc = connectorConfig.getProtocol();
        if (RemoteJmxProtocol.RMIJRMP != RemoteJmxProtocol.instance(pfc)) {
            final String port = connectorConfig.getPort();
            final String setP = connectorConfig.getProtocol();
            final String supportedP = RemoteJmxProtocol.RMIJRMP.getName();
            final String msg = sm.getString("rjmx.lc.unsupported_protocol", port, setP, supportedP);
            throw new ServerLifecycleException (msg);
        }
    }
    private void handleSsl() {
        final boolean ssl = connectorConfig.isSecurityEnabled();
        
        RMIServerSocketFactory sf = null;
        if (ssl) {
            driver.setSsl(ssl);
            final com.sun.enterprise.config.serverbeans.Ssl sslc = connectorConfig.getSsl();
            sf = new AdminSslServerSocketFactory(sslc, connectorConfig.getAddress());
            RMIClientSocketFactory cf = new AdminRMISSLClientSocketFactory();
            driver.setRmiClientSocketFactory(cf);
        } else sf = new RMIMultiHomedServerSocketFactory(connectorConfig.getAddress());
        driver.setRmiServerSocketFactory(sf);        
    }
    
    /** A method to set up the client side of the TLS connection. Here is the scenario: When
     * the system jmx connector is set up with TLS enabled, all the other server instances
     * need to have the RMIClientSocketFactory related environment. This method ensures that.
     * Since this method is called when the server end is being brought up with the startup, it
     * ensures that the setup happens early. This is also required in case of cascading where
     * the server instances have the TLS setup on the jmx-connectors that are started in their
     * life cycle. Even if the jmx connectors are not set up with TLS, it is okay to 
     * setup the client side. 
     */
    private void setupClientSide() {
        new AsTlsClientEnvSetter().setup();
    }

    private static class RmiTweaks {
        final static String SECURE_RMI_REGISTRY    = "com.sun.aas.jsr160.SecureRmiRegistry";
    }
}
