/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/**
 * PROPRIETARY/CONFIDENTIAL.  Use of this product is subject to license terms.
 *
 * Copyright 2004 by iPlanet/Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 */
package com.sun.enterprise.admin.server.core.channel;

import com.sun.enterprise.admin.event.DynamicReconfigEventListener;
import com.sun.enterprise.admin.event.DynamicReconfigEvent;
import com.sun.enterprise.admin.event.AdminEventListenerException;
import com.sun.enterprise.admin.server.core.channel.RMIClient;
import com.sun.enterprise.admin.server.core.channel.AdminChannel;

//i18n import
import com.sun.enterprise.util.i18n.StringManager;

/**
 * This is implemenation of DynamicReconfigEvent listener
 *
 * @author Satish Viswanatham
 */
public class DynamicReconfigEventListenerImpl 
                    implements DynamicReconfigEventListener {

  public void processEvent(DynamicReconfigEvent event) 
                            throws AdminEventListenerException{

    String inst = event.getInstanceName();
    if (inst == null) {
       String msg = localStrings.getString(
            "admin.server.core.channel.impl.no_inst_name");
       throw new AdminEventListenerException(msg); 
    }

    RMIClient client = AdminChannel.getRMIClient(inst);

    if (client == null) {
       String msg = localStrings.getString(
            "admin.server.core.channel.impl.no_rmi_client", inst);
       throw new AdminEventListenerException(msg); 
    }
    boolean resNeeded = client.isRestartNeeded();

    if (event.getActionType() == DynamicReconfigEvent.ACTION_ENABLED) {
        if (resNeeded == true) {
            // can not set dynamic reconfig, throw exception
           String msg = localStrings.getString(
            "admin.server.core.channel.impl.restart_required", inst);
            throw new AdminEventListenerException(msg);
        } 
    } else if (event.getActionType() == DynamicReconfigEvent.ACTION_DISABLED) {
        client.setRestartNeeded(true);
    }
  }

	// i18n StringManager
	private static StringManager localStrings =
		StringManager.getManager( DynamicReconfigEventListenerImpl.class );


}
